/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test.driver;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.util.KsqlException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.test.TestRecord;

public class TestDriverPipeline {
    private final Map<String, Topic> topics = new HashMap<String, Topic>();
    private final ListMultimap<String, TestRecord<GenericKey, GenericRow>> topicCache = ArrayListMultimap.create();
    private final Map<String, Integer> assertPositions = new HashMap<String, Integer>();

    private TestInputTopic createInputTopic(TopologyTestDriver driver, TopicInfo topic) {
        return driver.createInputTopic(topic.name, topic.keySerde.serializer(), topic.valueSerde.serializer());
    }

    private void replaceAllInputs(TopicInfo topic) {
        this.topics.get((Object)topic.name).topicAsInput.clear();
        this.topics.get((Object)topic.name).drivers.forEach(driver -> this.topics.get((Object)topic.name).topicAsInput.add((TestInputTopic<GenericKey, GenericRow>)this.createInputTopic((TopologyTestDriver)driver, topic)));
    }

    public void addDdlTopic(TopicInfo topic) {
        if (!this.topics.containsKey(topic.name)) {
            this.topics.put(topic.name, new Topic(topic.name));
        } else {
            this.replaceAllInputs(topic);
        }
    }

    public void addDriver(TopologyTestDriver driver, List<TopicInfo> inputTopics, TopicInfo outputTopic) {
        TestOutputTopic output = driver.createOutputTopic(outputTopic.name, outputTopic.keySerde.deserializer(), outputTopic.valueSerde.deserializer());
        if (!this.topics.containsKey(outputTopic.name)) {
            this.topics.put(outputTopic.name, new Topic(outputTopic.name));
        } else {
            this.replaceAllInputs(outputTopic);
        }
        this.topics.get((Object)outputTopic.name).topicAsOutput = Optional.of(output);
        for (TopicInfo inputTopic : inputTopics) {
            TestInputTopic input = this.createInputTopic(driver, inputTopic);
            if (!this.topics.containsKey(inputTopic.name)) {
                this.topics.put(inputTopic.name, new Topic(inputTopic.name));
            }
            this.topics.get((Object)inputTopic.name).topicAsInput.add((TestInputTopic<GenericKey, GenericRow>)input);
            this.topics.get((Object)inputTopic.name).receivers.add(this.topics.get(outputTopic.name));
            this.topics.get((Object)inputTopic.name).drivers.add(driver);
        }
    }

    public void pipeInput(String topic, GenericKey key, GenericRow value, long timestampMs) {
        this.pipeInput(topic, key, value, timestampMs, new HashSet<String>(), topic);
    }

    private void pipeInput(String topicName, GenericKey key, GenericRow value, long timestampMs, Set<String> loopDetection, String path) {
        boolean added = loopDetection.add(topicName);
        if (!added) {
            throw new KsqlException("Detected illegal cycle in topology: " + path);
        }
        if (!this.topics.containsKey(topicName)) {
            throw new KsqlException("Cannot pipe input to unknown source: " + topicName);
        }
        Topic topic = this.topics.get(topicName);
        if (topicName.equals(path)) {
            this.topicCache.put((Object)topicName, (Object)new TestRecord((Object)key, (Object)value, Instant.ofEpochMilli(timestampMs)));
        }
        for (TestInputTopic<GenericKey, GenericRow> input : topic.topicAsInput) {
            input.pipeInput((Object)key, (Object)value, timestampMs);
        }
        for (Topic receiver : topic.receivers) {
            for (TestRecord record : receiver.topicAsOutput.get().readRecordsToList()) {
                this.topicCache.put((Object)receiver.name, (Object)record);
                if (this.topics.get((Object)receiver.name).topicAsInput.size() <= 0) continue;
                this.pipeInput(receiver.name, (GenericKey)record.key(), (GenericRow)record.value(), record.timestamp(), new HashSet<String>(loopDetection), path + "->" + receiver.name);
            }
        }
    }

    public List<TestRecord<GenericKey, GenericRow>> getAllRecordsForTopic(String topic) {
        return this.topicCache.get((Object)topic);
    }

    public Iterator<TestRecord<GenericKey, GenericRow>> getRecordsForTopic(final String topic) {
        return new Iterator<TestRecord<GenericKey, GenericRow>>(){

            @Override
            public boolean hasNext() {
                int idx = TestDriverPipeline.this.assertPositions.getOrDefault(topic, 0);
                return TestDriverPipeline.this.topicCache.get((Object)topic).size() > idx;
            }

            @Override
            public TestRecord<GenericKey, GenericRow> next() {
                int idx = TestDriverPipeline.this.assertPositions.getOrDefault(topic, 0);
                TestDriverPipeline.this.assertPositions.put(topic, idx + 1);
                return (TestRecord)TestDriverPipeline.this.topicCache.get((Object)topic).get(idx);
            }
        };
    }

    public static final class TopicInfo {
        final String name;
        final Serde<?> keySerde;
        final Serde<GenericRow> valueSerde;

        public TopicInfo(String name, Serde<?> keySerde, Serde<GenericRow> valueSerde) {
            this.name = name;
            this.keySerde = keySerde;
            this.valueSerde = valueSerde;
        }
    }

    private static final class Topic {
        private final List<Topic> receivers = new ArrayList<Topic>();
        private final List<TopologyTestDriver> drivers = new ArrayList<TopologyTestDriver>();
        private final List<TestInputTopic<GenericKey, GenericRow>> topicAsInput = new ArrayList<TestInputTopic<GenericKey, GenericRow>>();
        private Optional<TestOutputTopic<GenericKey, GenericRow>> topicAsOutput = Optional.empty();
        private final String name;

        private Topic(String name) {
            this.name = name;
        }
    }
}

