/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test.parser;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.tools.test.KsqlTestException;
import io.confluent.ksql.tools.test.TestLoader;
import io.confluent.ksql.tools.test.model.Test;
import io.confluent.ksql.tools.test.model.TestLocation;
import io.confluent.ksql.tools.test.parser.SqlTestReader;
import io.confluent.ksql.tools.test.parser.TestDirective;
import io.confluent.ksql.tools.test.parser.TestStatement;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SqlTestLoader
implements TestLoader<SqlTest> {
    private final Predicate<SqlTest> shouldRun;
    private final Path path;

    public SqlTestLoader(Path path) {
        this(t -> true, path);
    }

    public SqlTestLoader(Predicate<SqlTest> testFilter, Path path) {
        this.shouldRun = Objects.requireNonNull(testFilter, "testFilter");
        this.path = Objects.requireNonNull(path, "path");
    }

    @Override
    public Stream<SqlTest> load() throws IOException {
        List files = Files.find(this.path, Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]).collect(Collectors.toList());
        ImmutableList.Builder builder = ImmutableList.builder();
        List<String> whiteList = TestLoader.getWhiteList();
        for (Path file : files) {
            if (!whiteList.isEmpty()) {
                if (!whiteList.stream().anyMatch(file::endsWith)) continue;
            }
            builder.addAll(this.loadTest(file));
        }
        return builder.build().stream();
    }

    public List<SqlTest> loadTest(Path path) throws IOException {
        return SqlTestLoader.loadTest(SqlTestReader.of(path), path, this.shouldRun);
    }

    public static List<SqlTest> loadTest(String test) {
        return SqlTestLoader.loadTest(SqlTestReader.of(test), null, t -> true);
    }

    private static List<SqlTest> loadTest(SqlTestReader reader, Path path, Predicate<SqlTest> shouldRun) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ArrayList<TestStatement> statements = null;
        String name = null;
        while (reader.hasNext()) {
            TestStatement statement = reader.next();
            Optional<String> nextName = statement.consumeDirective(directive -> directive.getType() == TestDirective.Type.TEST ? directive.getContents() : null);
            if (nextName.isPresent()) {
                if (statements != null) {
                    builder.add((Object)new SqlTest(path, name, statements));
                }
                statements = new ArrayList<TestStatement>();
                name = nextName.get();
            } else if (statements == null) {
                throw new KsqlTestException(statement, path, "Exepcted test to start with --@test.");
            }
            statements.add(statement);
        }
        builder.add((Object)new SqlTest(path, name, statements));
        return (List)builder.build().stream().filter(shouldRun).collect(ImmutableList.toImmutableList());
    }

    public static class SqlTest
    implements Test {
        private final Path file;
        private final String name;
        private final List<TestStatement> statements;

        public SqlTest(Path file, String name, List<TestStatement> statements) {
            this.file = file;
            this.name = name;
            this.statements = ImmutableList.copyOf(statements);
        }

        public Path getFile() {
            return this.file;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TestLocation getTestLocation() {
            return () -> this.file;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="statements is ImmutableList")
        public List<TestStatement> getStatements() {
            return this.statements;
        }
    }
}

