/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test.parser;

import com.google.common.base.Functions;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class TestDirective {
    private final Type type;
    private final String contents;
    private final NodeLocation location;

    TestDirective(Type type, String contents, NodeLocation location) {
        this.type = Objects.requireNonNull(type, "type");
        this.contents = Objects.requireNonNull(contents, "contents");
        this.location = Objects.requireNonNull(location, "location");
    }

    public Type getType() {
        return this.type;
    }

    public String getContents() {
        return this.contents;
    }

    public NodeLocation getLocation() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestDirective that = (TestDirective)o;
        return this.type == that.type && Objects.equals(this.contents, that.contents);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.contents});
    }

    public String toString() {
        return "--@" + this.type.getTypeName() + ": " + this.contents;
    }

    public static enum Type {
        TEST("test"),
        EXPECTED_ERROR("expected.error"),
        EXPECTED_MESSAGE("expected.message"),
        UNKNOWN("UNKNOWN");

        private static final Map<String, Type> NAME_MAP;
        private final String typeName;

        private Type(String typeName) {
            this.typeName = Objects.requireNonNull(typeName, "typeName");
        }

        public String getTypeName() {
            return this.typeName;
        }

        public static Type from(String typeName) {
            return NAME_MAP.getOrDefault(typeName, UNKNOWN);
        }

        static {
            NAME_MAP = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getTypeName, Functions.identity()));
        }
    }
}

