/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test.parser;

import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.AssertStatement;
import io.confluent.ksql.tools.test.parser.TestDirective;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public final class TestStatement {
    private final KsqlParser.ParsedStatement engineStatement;
    private final AssertStatement assertStatement;
    private final TestDirective directive;

    public static TestStatement of(KsqlParser.ParsedStatement engineStatement) {
        return new TestStatement(engineStatement, null, null);
    }

    public static TestStatement of(AssertStatement assertStatement) {
        return new TestStatement(null, assertStatement, null);
    }

    public static TestStatement of(TestDirective directive) {
        return new TestStatement(null, null, directive);
    }

    private TestStatement(KsqlParser.ParsedStatement engineStatement, AssertStatement assertStatement, TestDirective directive) {
        boolean exactlyOne;
        this.engineStatement = engineStatement;
        this.assertStatement = assertStatement;
        this.directive = directive;
        boolean bl = exactlyOne = Stream.of(engineStatement, assertStatement, directive).filter(Objects::nonNull).count() == 1L;
        if (!exactlyOne) {
            throw new IllegalStateException(String.format("Expected exactly one of engine, assert or directive statement. Got (%s, %s, %s).", engineStatement, assertStatement, directive));
        }
    }

    public void consume(Consumer<KsqlParser.ParsedStatement> parsedStatementConsumer, Consumer<AssertStatement> assertStatementConsumer, Consumer<TestDirective> testDirectiveConsumer) {
        if (this.engineStatement != null) {
            parsedStatementConsumer.accept(this.engineStatement);
        } else if (this.assertStatement != null) {
            assertStatementConsumer.accept(this.assertStatement);
        } else if (this.directive != null) {
            testDirectiveConsumer.accept(this.directive);
        }
    }

    public <T> T apply(Function<KsqlParser.ParsedStatement, T> parsedStatementFunction, Function<AssertStatement, T> assertStatementFunction, Function<TestDirective, T> testDirectiveFunction) {
        if (this.engineStatement != null) {
            return parsedStatementFunction.apply(this.engineStatement);
        }
        if (this.assertStatement != null) {
            return assertStatementFunction.apply(this.assertStatement);
        }
        if (this.directive != null) {
            return testDirectiveFunction.apply(this.directive);
        }
        throw new IllegalStateException("Should not happen if TestStatement is properly implemented");
    }

    public <T> Optional<T> consumeDirective(Function<TestDirective, T> fun) {
        if (this.directive == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(fun.apply(this.directive));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestStatement that = (TestStatement)o;
        return Objects.equals(this.engineStatement, that.engineStatement) && Objects.equals(this.assertStatement, that.assertStatement) && Objects.equals(this.directive, that.directive);
    }

    public String toString() {
        return "TestStatement{engineStatement=" + String.valueOf(this.engineStatement) + ", assertStatement=" + String.valueOf(this.assertStatement) + ", directive=" + String.valueOf(this.directive) + "}";
    }

    public int hashCode() {
        return Objects.hash(this.engineStatement, this.assertStatement, this.directive);
    }
}

