/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test.stubs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.exception.KafkaResponseGetFailedException;
import io.confluent.ksql.services.KafkaConsumerGroupClient;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class StubKafkaConsumerGroupClient
implements KafkaConsumerGroupClient {
    private static final List<String> groups = ImmutableList.of((Object)"cg1", (Object)"cg2");

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="groups is ImmutableList")
    public List<String> listGroups() {
        return groups;
    }

    public KafkaConsumerGroupClient.ConsumerGroupSummary describeConsumerGroup(String group) {
        if (groups.contains(group)) {
            ImmutableSet instances = ImmutableSet.of((Object)new KafkaConsumerGroupClient.ConsumerSummary(group + "-1"), (Object)new KafkaConsumerGroupClient.ConsumerSummary(group + "-2"));
            return new KafkaConsumerGroupClient.ConsumerGroupSummary((Set)instances);
        }
        throw new KafkaResponseGetFailedException("Failed to retrieve Kafka consumer groups", (Throwable)new RuntimeException());
    }

    public Map<TopicPartition, OffsetAndMetadata> listConsumerGroupOffsets(String group) {
        if (groups.contains(group)) {
            LinkedHashMap<TopicPartition, OffsetAndMetadata> offsets = new LinkedHashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(new TopicPartition("topic1", 0), new OffsetAndMetadata(10L));
            offsets.put(new TopicPartition("topic1", 1), new OffsetAndMetadata(11L));
            return offsets;
        }
        throw new KafkaResponseGetFailedException("Failed to retrieve Kafka consumer groups", (Throwable)new RuntimeException());
    }

    public void deleteConsumerGroups(Set<String> groups) {
    }
}

