/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.ForeignKeyTableTableJoin;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.JoinType;
import io.confluent.ksql.execution.plan.KGroupedStreamHolder;
import io.confluent.ksql.execution.plan.KGroupedTableHolder;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.plan.StreamAggregate;
import io.confluent.ksql.execution.plan.StreamFilter;
import io.confluent.ksql.execution.plan.StreamFlatMap;
import io.confluent.ksql.execution.plan.StreamGroupBy;
import io.confluent.ksql.execution.plan.StreamGroupByKey;
import io.confluent.ksql.execution.plan.StreamSelect;
import io.confluent.ksql.execution.plan.StreamSelectKey;
import io.confluent.ksql.execution.plan.StreamSink;
import io.confluent.ksql.execution.plan.StreamSource;
import io.confluent.ksql.execution.plan.StreamStreamJoin;
import io.confluent.ksql.execution.plan.StreamTableJoin;
import io.confluent.ksql.execution.plan.StreamWindowedAggregate;
import io.confluent.ksql.execution.plan.TableAggregate;
import io.confluent.ksql.execution.plan.TableFilter;
import io.confluent.ksql.execution.plan.TableGroupBy;
import io.confluent.ksql.execution.plan.TableSelect;
import io.confluent.ksql.execution.plan.TableSelectKey;
import io.confluent.ksql.execution.plan.TableSink;
import io.confluent.ksql.execution.plan.TableSource;
import io.confluent.ksql.execution.plan.TableSourceV1;
import io.confluent.ksql.execution.plan.TableSuppress;
import io.confluent.ksql.execution.plan.TableTableJoin;
import io.confluent.ksql.execution.plan.WindowedStreamSource;
import io.confluent.ksql.execution.plan.WindowedTableSource;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.RefinementInfo;
import io.confluent.ksql.serde.WindowInfo;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.kafka.streams.kstream.JoinWindows;

public final class ExecutionStepFactory {
    private ExecutionStepFactory() {
    }

    public static WindowedStreamSource streamSourceWindowed(QueryContext.Stacker stacker, LogicalSchema sourceSchema, String topicName, Formats formats, WindowInfo windowInfo, Optional<TimestampColumn> timestampColumn, int pseudoColumnVersion) {
        QueryContext queryContext = stacker.getQueryContext();
        return new WindowedStreamSource(new ExecutionStepPropertiesV1(queryContext), topicName, formats, windowInfo, timestampColumn, sourceSchema, OptionalInt.of(pseudoColumnVersion));
    }

    public static StreamSource streamSource(QueryContext.Stacker stacker, LogicalSchema sourceSchema, String topicName, Formats formats, Optional<TimestampColumn> timestampColumn, int pseudoColumnVersion) {
        QueryContext queryContext = stacker.getQueryContext();
        return new StreamSource(new ExecutionStepPropertiesV1(queryContext), topicName, formats, timestampColumn, sourceSchema, OptionalInt.of(pseudoColumnVersion));
    }

    public static TableSourceV1 tableSourceV1(QueryContext.Stacker stacker, LogicalSchema sourceSchema, String topicName, Formats formats, Optional<TimestampColumn> timestampColumn, int pseudoColumnVersion) {
        QueryContext queryContext = stacker.getQueryContext();
        return new TableSourceV1(new ExecutionStepPropertiesV1(queryContext), topicName, formats, timestampColumn, sourceSchema, Optional.of(true), OptionalInt.of(pseudoColumnVersion));
    }

    public static TableSource tableSource(QueryContext.Stacker stacker, LogicalSchema sourceSchema, String topicName, Formats formats, Optional<TimestampColumn> timestampColumn, Formats stateStoreFormats, int pseudoColumnVersion) {
        QueryContext queryContext = stacker.getQueryContext();
        return new TableSource(new ExecutionStepPropertiesV1(queryContext), topicName, formats, timestampColumn, sourceSchema, pseudoColumnVersion, stateStoreFormats);
    }

    public static WindowedTableSource tableSourceWindowed(QueryContext.Stacker stacker, LogicalSchema sourceSchema, String topicName, Formats formats, WindowInfo windowInfo, Optional<TimestampColumn> timestampColumn, int pseudoColumnVersion) {
        QueryContext queryContext = stacker.getQueryContext();
        return new WindowedTableSource(new ExecutionStepPropertiesV1(queryContext), topicName, formats, windowInfo, timestampColumn, sourceSchema, OptionalInt.of(pseudoColumnVersion));
    }

    public static <K> StreamSink<K> streamSink(QueryContext.Stacker stacker, Formats formats, ExecutionStep<KStreamHolder<K>> source, String topicName, Optional<TimestampColumn> timestampColumn) {
        QueryContext queryContext = stacker.getQueryContext();
        return new StreamSink(new ExecutionStepPropertiesV1(queryContext), source, formats, topicName, timestampColumn);
    }

    public static <K> StreamFlatMap<K> streamFlatMap(QueryContext.Stacker stacker, ExecutionStep<KStreamHolder<K>> source, List<FunctionCall> tableFunctions) {
        QueryContext queryContext = stacker.getQueryContext();
        return new StreamFlatMap(new ExecutionStepPropertiesV1(queryContext), source, tableFunctions);
    }

    public static <K> StreamFilter<K> streamFilter(QueryContext.Stacker stacker, ExecutionStep<KStreamHolder<K>> source, Expression filterExpression) {
        QueryContext queryContext = stacker.getQueryContext();
        return new StreamFilter(new ExecutionStepPropertiesV1(queryContext), source, filterExpression);
    }

    public static <K> StreamSelect<K> streamSelect(QueryContext.Stacker stacker, ExecutionStep<KStreamHolder<K>> source, List<ColumnName> keyColumnNames, Optional<List<ColumnName>> selectedKeys, List<SelectExpression> selectExpressions) {
        ExecutionStepPropertiesV1 properties = new ExecutionStepPropertiesV1(stacker.getQueryContext());
        return new StreamSelect(properties, source, keyColumnNames, selectedKeys, selectExpressions);
    }

    public static <K> StreamTableJoin<K> streamTableJoin(QueryContext.Stacker stacker, JoinType joinType, ColumnName keyColName, Formats formats, ExecutionStep<KStreamHolder<K>> left, ExecutionStep<KTableHolder<K>> right) {
        QueryContext queryContext = stacker.getQueryContext();
        return new StreamTableJoin(new ExecutionStepPropertiesV1(queryContext), joinType, keyColName, formats, left, right);
    }

    public static <K> StreamStreamJoin<K> streamStreamJoin(QueryContext.Stacker stacker, JoinType joinType, ColumnName keyColName, Formats leftFormats, Formats rightFormats, ExecutionStep<KStreamHolder<K>> left, ExecutionStep<KStreamHolder<K>> right, JoinWindows joinWindows, Optional<WindowTimeClause> gracePeriod) {
        QueryContext queryContext = stacker.getQueryContext();
        return new StreamStreamJoin(new ExecutionStepPropertiesV1(queryContext), joinType, keyColName, leftFormats, rightFormats, left, right, Duration.ofMillis(joinWindows.beforeMs), Duration.ofMillis(joinWindows.afterMs), gracePeriod.map(grace -> Duration.ofMillis(grace.toDuration().toMillis())));
    }

    public static <K> StreamSelectKey<K> streamSelectKey(QueryContext.Stacker stacker, ExecutionStep<? extends KStreamHolder<K>> source, List<Expression> partitionBys) {
        ExecutionStepPropertiesV1 props = new ExecutionStepPropertiesV1(stacker.getQueryContext());
        return new StreamSelectKey(props, source, partitionBys);
    }

    public static <K> TableSink<K> tableSink(QueryContext.Stacker stacker, ExecutionStep<KTableHolder<K>> source, Formats formats, String topicName, Optional<TimestampColumn> timestampColumn) {
        QueryContext queryContext = stacker.getQueryContext();
        return new TableSink(new ExecutionStepPropertiesV1(queryContext), source, formats, topicName, timestampColumn);
    }

    public static <K> TableFilter<K> tableFilter(QueryContext.Stacker stacker, ExecutionStep<KTableHolder<K>> source, Expression filterExpression) {
        QueryContext queryContext = stacker.getQueryContext();
        return new TableFilter(new ExecutionStepPropertiesV1(queryContext), source, filterExpression);
    }

    public static <K> TableSelect<K> tableMapValues(QueryContext.Stacker stacker, ExecutionStep<KTableHolder<K>> source, List<ColumnName> keyColumnNames, List<SelectExpression> selectExpressions, Formats format) {
        ExecutionStepPropertiesV1 properties = new ExecutionStepPropertiesV1(stacker.getQueryContext());
        return new TableSelect(properties, source, keyColumnNames, selectExpressions, Optional.ofNullable(format));
    }

    public static <K> TableTableJoin<K> tableTableJoin(QueryContext.Stacker stacker, JoinType joinType, ColumnName keyColName, ExecutionStep<KTableHolder<K>> left, ExecutionStep<KTableHolder<K>> right) {
        QueryContext queryContext = stacker.getQueryContext();
        return new TableTableJoin(new ExecutionStepPropertiesV1(queryContext), joinType, keyColName, left, right);
    }

    public static <KLeftT, KRightT> ForeignKeyTableTableJoin<KLeftT, KRightT> foreignKeyTableTableJoin(QueryContext.Stacker stacker, JoinType joinType, Optional<ColumnName> leftJoinColumnName, Formats formats, ExecutionStep<KTableHolder<KLeftT>> left, ExecutionStep<KTableHolder<KRightT>> right, Optional<Expression> leftJoinExpression) {
        QueryContext queryContext = stacker.getQueryContext();
        return new ForeignKeyTableTableJoin(new ExecutionStepPropertiesV1(queryContext), joinType, leftJoinColumnName, leftJoinExpression, formats, left, right);
    }

    public static StreamAggregate streamAggregate(QueryContext.Stacker stacker, ExecutionStep<KGroupedStreamHolder> sourceStep, Formats formats, List<ColumnName> nonAggregateColumns, List<FunctionCall> aggregations) {
        QueryContext queryContext = stacker.getQueryContext();
        return new StreamAggregate(new ExecutionStepPropertiesV1(queryContext), sourceStep, formats, nonAggregateColumns, aggregations);
    }

    public static StreamWindowedAggregate streamWindowedAggregate(QueryContext.Stacker stacker, ExecutionStep<KGroupedStreamHolder> sourceStep, Formats formats, List<ColumnName> nonAggregateColumns, List<FunctionCall> aggregations, KsqlWindowExpression window) {
        QueryContext queryContext = stacker.getQueryContext();
        return new StreamWindowedAggregate(new ExecutionStepPropertiesV1(queryContext), sourceStep, formats, nonAggregateColumns, aggregations, window);
    }

    public static <K> StreamGroupBy<K> streamGroupBy(QueryContext.Stacker stacker, ExecutionStep<KStreamHolder<K>> sourceStep, Formats format, List<Expression> groupingExpressions) {
        QueryContext queryContext = stacker.getQueryContext();
        return new StreamGroupBy(new ExecutionStepPropertiesV1(queryContext), sourceStep, format, groupingExpressions);
    }

    public static StreamGroupByKey streamGroupByKey(QueryContext.Stacker stacker, ExecutionStep<KStreamHolder<GenericKey>> sourceStep, Formats formats) {
        QueryContext queryContext = stacker.getQueryContext();
        return new StreamGroupByKey(new ExecutionStepPropertiesV1(queryContext), sourceStep, formats);
    }

    public static TableAggregate tableAggregate(QueryContext.Stacker stacker, ExecutionStep<KGroupedTableHolder> sourceStep, Formats formats, List<ColumnName> nonAggregateColumns, List<FunctionCall> aggregations) {
        QueryContext queryContext = stacker.getQueryContext();
        return new TableAggregate(new ExecutionStepPropertiesV1(queryContext), sourceStep, formats, nonAggregateColumns, aggregations);
    }

    public static <K> TableGroupBy<K> tableGroupBy(QueryContext.Stacker stacker, ExecutionStep<KTableHolder<K>> sourceStep, Formats format, List<Expression> groupingExpressions) {
        QueryContext queryContext = stacker.getQueryContext();
        return new TableGroupBy(new ExecutionStepPropertiesV1(queryContext), sourceStep, format, groupingExpressions);
    }

    public static <K> TableSelectKey<K> tableSelectKey(QueryContext.Stacker stacker, ExecutionStep<? extends KTableHolder<K>> source, Formats formats, List<Expression> partitionBys) {
        ExecutionStepPropertiesV1 props = new ExecutionStepPropertiesV1(stacker.getQueryContext());
        return new TableSelectKey(props, source, formats, partitionBys);
    }

    public static <K> TableSuppress<K> tableSuppress(QueryContext.Stacker stacker, ExecutionStep<KTableHolder<K>> sourceStep, RefinementInfo refinementInfo, Formats formats) {
        QueryContext queryContext = stacker.getQueryContext();
        return new TableSuppress(new ExecutionStepPropertiesV1(queryContext), sourceStep, refinementInfo, formats);
    }
}

