/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.execution.streams.ForeignKeyJoinParams;
import io.confluent.ksql.execution.streams.KsqlKeyExtractor;
import io.confluent.ksql.execution.streams.KsqlValueJoiner;
import io.confluent.ksql.execution.transform.ExpressionEvaluator;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.schema.ksql.LogicalSchema;

public final class ForeignKeyJoinParamsFactory {
    private ForeignKeyJoinParamsFactory() {
    }

    public static <KRightT> ForeignKeyJoinParams<KRightT> create(ExpressionEvaluator expressionEvaluator, LogicalSchema leftSchema, LogicalSchema rightSchema, ProcessingLogger processingLogger) {
        if (rightSchema.key().size() != 1) {
            throw new IllegalStateException("rightSchema must have single column key");
        }
        return new ForeignKeyJoinParams(new KsqlKeyExtractor(expressionEvaluator, processingLogger), new KsqlValueJoiner(leftSchema.value().size(), rightSchema.value().size(), 0), ForeignKeyJoinParamsFactory.createSchema(leftSchema, rightSchema));
    }

    public static LogicalSchema createSchema(LogicalSchema leftSchema, LogicalSchema rightSchema) {
        LogicalSchema.Builder builder = LogicalSchema.builder().keyColumns((Iterable)leftSchema.key()).valueColumns((Iterable)leftSchema.value()).valueColumns((Iterable)rightSchema.value());
        return builder.build();
    }
}

