/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CompiledExpression;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.streams.GroupByParams;
import io.confluent.ksql.logging.processing.NoopProcessingLogContext;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.RecordProcessingError;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.ColumnAliasGenerator;
import io.confluent.ksql.schema.ksql.ColumnNames;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;

final class GroupByParamsFactory {
    private static final Object EVAL_FAILED = new Object();

    private GroupByParamsFactory() {
    }

    public static LogicalSchema buildSchema(LogicalSchema sourceSchema, List<CompiledExpression> groupBys) {
        ProcessingLogger logger = NoopProcessingLogContext.NOOP_LOGGER;
        return GroupByParamsFactory.buildGrouper(sourceSchema, groupBys, logger).getSchema();
    }

    public static GroupByParams build(LogicalSchema sourceSchema, List<CompiledExpression> groupBys, ProcessingLogger logger) {
        if (groupBys.isEmpty()) {
            throw new IllegalArgumentException("No GROUP BY groupBys");
        }
        Grouper grouper = GroupByParamsFactory.buildGrouper(sourceSchema, groupBys, logger);
        return new GroupByParams(grouper.getSchema(), grouper::apply);
    }

    private static Grouper buildGrouper(LogicalSchema sourceSchema, List<CompiledExpression> groupBys, ProcessingLogger logger) {
        return new ExpressionGrouper(sourceSchema, groupBys, logger);
    }

    private static Object processColumn(int index, CompiledExpression exp, GenericRow row, ProcessingLogger logger) {
        Supplier<String> errorMsgSupplier = () -> "Error calculating group-by column with index " + index + ". The source row will be excluded from the table.";
        Object result = exp.evaluate(row, EVAL_FAILED, logger, errorMsgSupplier);
        if (result == EVAL_FAILED) {
            return null;
        }
        if (result == null) {
            logger.error(RecordProcessingError.recordProcessingError((String)("Group-by column with index " + index + " resolved to null. The source row will be excluded from the table."), (GenericRow)row));
            return null;
        }
        return result;
    }

    private static LogicalSchema expressionSchema(LogicalSchema sourceSchema, List<CompiledExpression> groupBys) {
        ColumnAliasGenerator columnAliasGenerator = ColumnNames.columnAliasGenerator(Stream.of(sourceSchema));
        LogicalSchema.Builder schemaBuilder = LogicalSchema.builder();
        for (CompiledExpression groupBy : groupBys) {
            Expression groupByExp = groupBy.getExpression();
            ColumnName columnName = groupByExp instanceof ColumnReferenceExp ? ((ColumnReferenceExp)groupByExp).getColumnName() : columnAliasGenerator.uniqueAliasFor(groupByExp);
            schemaBuilder.keyColumn(columnName, groupBy.getExpressionType());
        }
        schemaBuilder.valueColumns((Iterable)sourceSchema.value());
        return schemaBuilder.build();
    }

    private static interface Grouper {
        public LogicalSchema getSchema();

        public GenericKey apply(GenericRow var1);
    }

    private static final class ExpressionGrouper
    implements Grouper {
        private final LogicalSchema schema;
        private final ImmutableList<CompiledExpression> groupBys;
        private final ProcessingLogger logger;

        ExpressionGrouper(LogicalSchema sourceSchema, List<CompiledExpression> groupBys, ProcessingLogger logger) {
            this.schema = GroupByParamsFactory.expressionSchema(sourceSchema, groupBys);
            this.groupBys = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupBys, "groupBys"));
            this.logger = Objects.requireNonNull(logger, "logger");
            if (this.groupBys.isEmpty()) {
                throw new IllegalArgumentException("Empty group by");
            }
        }

        @Override
        public LogicalSchema getSchema() {
            return this.schema;
        }

        @Override
        public GenericKey apply(GenericRow row) {
            GenericKey.Builder builder = GenericKey.builder((int)this.groupBys.size());
            for (int i = 0; i < this.groupBys.size(); ++i) {
                Object result = GroupByParamsFactory.processColumn(i, (CompiledExpression)this.groupBys.get(i), row, this.logger);
                if (result == null) {
                    return null;
                }
                builder.append(result);
            }
            return builder.build();
        }
    }
}

