/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.codegen.CompiledExpression;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.NullLiteral;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.streams.PartitionByParams;
import io.confluent.ksql.execution.util.ColumnExtractor;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.execution.util.KeyUtil;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.ColumnAliasGenerator;
import io.confluent.ksql.schema.ksql.ColumnNames;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.streams.KeyValue;

public final class PartitionByParamsFactory {
    private PartitionByParamsFactory() {
    }

    public static <K> PartitionByParams<K> build(LogicalSchema sourceSchema, ExecutionKeyFactory<K> serdeFactory, List<Expression> partitionBys, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry, ProcessingLogger logger) {
        PartitionByParams.Mapper<K> mapper;
        List<PartitionByColumn> partitionByCols = PartitionByParamsFactory.getPartitionByColumnName(sourceSchema, partitionBys);
        LogicalSchema resultSchema = PartitionByParamsFactory.buildSchema(sourceSchema, partitionBys, functionRegistry, partitionByCols);
        if (PartitionByParamsFactory.isPartitionByNull(partitionBys)) {
            mapper = (k, v) -> new KeyValue(null, v);
        } else {
            List<PartitionByExpressionEvaluator> evaluators = partitionBys.stream().map(pby -> {
                Set sourceColsInPartitionBy = ColumnExtractor.extractColumns((Expression)pby);
                boolean partitionByInvolvesKeyColsOnly = sourceColsInPartitionBy.stream().map(ColumnReferenceExp::getColumnName).allMatch(arg_0 -> ((LogicalSchema)sourceSchema).isKeyColumn(arg_0));
                return PartitionByParamsFactory.buildExpressionEvaluator(sourceSchema, pby, ksqlConfig, functionRegistry, logger, partitionByInvolvesKeyColsOnly);
            }).collect(Collectors.toList());
            mapper = PartitionByParamsFactory.buildMapper(partitionByCols, evaluators, serdeFactory);
        }
        return new PartitionByParams(resultSchema, mapper);
    }

    public static LogicalSchema buildSchema(LogicalSchema sourceSchema, List<Expression> partitionBys, FunctionRegistry functionRegistry) {
        List<PartitionByColumn> partitionByCols = PartitionByParamsFactory.getPartitionByColumnName(sourceSchema, partitionBys);
        return PartitionByParamsFactory.buildSchema(sourceSchema, partitionBys, functionRegistry, partitionByCols);
    }

    private static LogicalSchema buildSchema(LogicalSchema sourceSchema, List<Expression> partitionBys, FunctionRegistry functionRegistry, List<PartitionByColumn> partitionByCols) {
        int i;
        ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(sourceSchema, functionRegistry);
        List keyTypes = partitionBys.stream().map(arg_0 -> ((ExpressionTypeManager)expressionTypeManager).getExpressionSqlType(arg_0)).collect(Collectors.toList());
        if (PartitionByParamsFactory.isPartitionByNull(partitionBys)) {
            LogicalSchema.Builder builder = LogicalSchema.builder();
            builder.valueColumns((Iterable)sourceSchema.value());
            return builder.build();
        }
        LogicalSchema.Builder builder = LogicalSchema.builder();
        for (i = 0; i < partitionBys.size(); ++i) {
            builder.keyColumn(partitionByCols.get((int)i).name, (SqlType)keyTypes.get(i));
        }
        builder.valueColumns((Iterable)sourceSchema.value());
        for (i = 0; i < partitionBys.size(); ++i) {
            if (!partitionByCols.get((int)i).shouldAppend) continue;
            builder.valueColumn(partitionByCols.get((int)i).name, (SqlType)keyTypes.get(i));
        }
        return builder.build();
    }

    public static boolean isPartitionByNull(List<Expression> partitionBys) {
        boolean nullExpressionPresent = partitionBys.stream().anyMatch(pb -> pb instanceof NullLiteral);
        if (!nullExpressionPresent) {
            return false;
        }
        if (partitionBys.size() > 1) {
            throw new KsqlException("Cannot PARTITION BY multiple columns including NULL");
        }
        return true;
    }

    private static List<PartitionByColumn> getPartitionByColumnName(LogicalSchema sourceSchema, List<Expression> partitionByExpressions) {
        ColumnAliasGenerator columnAliasGenerator = ColumnNames.columnAliasGenerator(Stream.of(sourceSchema));
        return partitionByExpressions.stream().map(partitionBy -> {
            if (partitionBy instanceof ColumnReferenceExp) {
                ColumnName columnName = ((ColumnReferenceExp)partitionBy).getColumnName();
                Column column = (Column)sourceSchema.findValueColumn(columnName).orElseThrow(() -> new IllegalStateException("Unknown partition by column: " + String.valueOf(columnName)));
                return new PartitionByColumn(column.name(), false);
            }
            return new PartitionByColumn(columnAliasGenerator.uniqueAliasFor(partitionBy), true);
        }).collect(Collectors.toList());
    }

    private static <K> PartitionByParams.Mapper<K> buildMapper(List<PartitionByColumn> partitionByCols, List<PartitionByExpressionEvaluator> evaluators, ExecutionKeyFactory<K> executionKeyFactory) {
        return (oldK, row) -> {
            List newKeyComponents = evaluators.stream().map(evaluator -> evaluator.evaluate(oldK, (GenericRow)row)).collect(Collectors.toList());
            Object key = executionKeyFactory.constructNewKey(oldK, GenericKey.fromList(newKeyComponents));
            if (row != null) {
                for (int i = 0; i < partitionByCols.size(); ++i) {
                    if (!((PartitionByColumn)partitionByCols.get((int)i)).shouldAppend) continue;
                    row.append(newKeyComponents.get(i));
                }
            }
            return new KeyValue(key, row);
        };
    }

    private static PartitionByExpressionEvaluator buildExpressionEvaluator(LogicalSchema schema, Expression partitionBy, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry, ProcessingLogger logger, boolean partitionByInvolvesKeyColsOnly) {
        CodeGenRunner codeGen = new CodeGenRunner(partitionByInvolvesKeyColsOnly ? schema.withKeyColsOnly() : schema, ksqlConfig, functionRegistry);
        CompiledExpression compiledExpression = codeGen.buildCodeGenFromParseTree(partitionBy, "SelectKey");
        String errorMsg = "Error computing new key from expression " + String.valueOf(compiledExpression.getExpression());
        return new PartitionByExpressionEvaluator(compiledExpression, logger, () -> errorMsg, partitionByInvolvesKeyColsOnly);
    }

    private static class PartitionByColumn {
        final ColumnName name;
        final boolean shouldAppend;

        PartitionByColumn(ColumnName name, boolean shouldAppend) {
            this.name = Objects.requireNonNull(name, "name");
            this.shouldAppend = shouldAppend;
        }
    }

    private static class PartitionByExpressionEvaluator {
        private final CompiledExpression compiledExpression;
        private final ProcessingLogger logger;
        private final Supplier<String> errorMsg;
        private final boolean evaluateOnKeyOnly;

        PartitionByExpressionEvaluator(CompiledExpression compiledExpression, ProcessingLogger logger, Supplier<String> errorMsg, boolean evaluateOnKeyOnly) {
            this.compiledExpression = Objects.requireNonNull(compiledExpression, "compiledExpression");
            this.logger = Objects.requireNonNull(logger, "logger");
            this.errorMsg = Objects.requireNonNull(errorMsg, "errorMsg");
            this.evaluateOnKeyOnly = evaluateOnKeyOnly;
        }

        Object evaluate(Object key, GenericRow value) {
            GenericRow row = this.evaluateOnKeyOnly ? GenericRow.fromList((List)KeyUtil.asList((Object)key)) : value;
            return this.compiledExpression.evaluate(row, null, this.logger, this.errorMsg);
        }
    }
}

