/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.StreamFilter;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.SqlPredicateFactory;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.execution.streams.process.KsFlatTransformedValueProcessor;
import io.confluent.ksql.execution.transform.KsqlFlatTransformer;
import io.confluent.ksql.execution.transform.sqlpredicate.SqlPredicate;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Named;

public final class StreamFilterBuilder {
    private StreamFilterBuilder() {
    }

    public static <K> KStreamHolder<K> build(KStreamHolder<K> stream, StreamFilter<K> step, RuntimeBuildContext buildContext) {
        return StreamFilterBuilder.build(stream, step, buildContext, SqlPredicate::new);
    }

    static <K> KStreamHolder<K> build(KStreamHolder<K> streamHolder, StreamFilter<K> step, RuntimeBuildContext buildContext, SqlPredicateFactory predicateFactory) {
        SqlPredicate predicate = predicateFactory.create(step.getFilterExpression(), streamHolder.getSchema(), buildContext.getKsqlConfig(), buildContext.getFunctionRegistry());
        ProcessingLogger processingLogger = buildContext.getProcessingLogger(step.getProperties().getQueryContext());
        KStream stream = streamHolder.getStream();
        stream.peek((k, v) -> {});
        KStream filtered = stream.processValues(() -> new KsFlatTransformedValueProcessor(new KsqlFlatTransformer(predicate.getTransformer(processingLogger))), Named.as((String)StreamsUtil.buildOpName(step.getProperties().getQueryContext())), new String[0]);
        return streamHolder.withStream(filtered, streamHolder.getSchema());
    }
}

