/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.codegen.CompiledExpression;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.function.UdtfUtil;
import io.confluent.ksql.execution.function.udtf.KudtfFlatMapper;
import io.confluent.ksql.execution.function.udtf.TableFunctionApplier;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.StreamFlatMap;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.execution.streams.process.KsFlatTransformedValueProcessor;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.KsqlTableFunction;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.ColumnNames;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Named;

public final class StreamFlatMapBuilder {
    private StreamFlatMapBuilder() {
    }

    public static <K> KStreamHolder<K> build(KStreamHolder<K> stream, StreamFlatMap<K> step, RuntimeBuildContext buildContext) {
        List tableFunctions = step.getTableFunctions();
        LogicalSchema schema = stream.getSchema();
        ImmutableList.Builder tableFunctionAppliersBuilder = ImmutableList.builder();
        CodeGenRunner codeGenRunner = new CodeGenRunner(schema, buildContext.getKsqlConfig(), buildContext.getFunctionRegistry());
        for (FunctionCall functionCall : tableFunctions) {
            ArrayList<CompiledExpression> compiledExpressionList = new ArrayList<CompiledExpression>(functionCall.getArguments().size());
            for (Expression expression : functionCall.getArguments()) {
                CompiledExpression compiledExpression = codeGenRunner.buildCodeGenFromParseTree(expression, "Table function");
                compiledExpressionList.add(compiledExpression);
            }
            KsqlTableFunction tableFunction = UdtfUtil.resolveTableFunction((FunctionRegistry)buildContext.getFunctionRegistry(), (FunctionCall)functionCall, (LogicalSchema)schema);
            TableFunctionApplier tableFunctionApplier = new TableFunctionApplier(tableFunction, compiledExpressionList);
            tableFunctionAppliersBuilder.add((Object)tableFunctionApplier);
        }
        QueryContext queryContext = step.getProperties().getQueryContext();
        ProcessingLogger processingLogger = buildContext.getProcessingLogger(queryContext);
        ImmutableList tableFunctionAppliers = tableFunctionAppliersBuilder.build();
        KStream mapped = stream.getStream().processValues(() -> new KsFlatTransformedValueProcessor(new KudtfFlatMapper((List)tableFunctionAppliers, processingLogger)), Named.as((String)StreamsUtil.buildOpName(queryContext)), new String[0]);
        return stream.withStream(mapped, StreamFlatMapBuilder.buildSchema(stream.getSchema(), step.getTableFunctions(), buildContext.getFunctionRegistry()));
    }

    public static LogicalSchema buildSchema(LogicalSchema inputSchema, List<FunctionCall> tableFunctions, FunctionRegistry functionRegistry) {
        LogicalSchema.Builder schemaBuilder = LogicalSchema.builder();
        List cols = inputSchema.value();
        schemaBuilder.keyColumns((Iterable)inputSchema.key());
        for (Column col : cols) {
            schemaBuilder.valueColumn((SimpleColumn)col);
        }
        ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(inputSchema, functionRegistry);
        for (int i = 0; i < tableFunctions.size(); ++i) {
            FunctionCall functionCall = tableFunctions.get(i);
            ColumnName colName = ColumnNames.synthesisedSchemaColumn((int)i);
            SqlType fieldType = expressionTypeManager.getExpressionSqlType((Expression)functionCall);
            schemaBuilder.valueColumn(colName, fieldType);
        }
        return schemaBuilder.build();
    }
}

