/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.StreamSelectKey;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.PartitionByParams;
import io.confluent.ksql.execution.streams.PartitionByParamsFactory;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Named;

public final class StreamSelectKeyBuilder {
    private StreamSelectKeyBuilder() {
    }

    public static <K> KStreamHolder<K> build(KStreamHolder<K> stream, StreamSelectKey<K> selectKey, RuntimeBuildContext buildContext) {
        return StreamSelectKeyBuilder.build(stream, selectKey, buildContext, PartitionByParamsFactory::build);
    }

    @VisibleForTesting
    static <K> KStreamHolder<K> build(KStreamHolder<K> stream, StreamSelectKey<K> selectKey, RuntimeBuildContext buildContext, PartitionByParamsBuilder paramsBuilder) {
        LogicalSchema sourceSchema = stream.getSchema();
        QueryContext queryContext = selectKey.getProperties().getQueryContext();
        ProcessingLogger logger = buildContext.getProcessingLogger(queryContext);
        PartitionByParams params = paramsBuilder.build(sourceSchema, stream.getExecutionKeyFactory(), selectKey.getKeyExpressions(), buildContext.getKsqlConfig(), buildContext.getFunctionRegistry(), logger);
        PartitionByParams.Mapper mapper = params.getMapper();
        KStream kStream = stream.getStream();
        KStream reKeyed = kStream.map(mapper, Named.as((String)(queryContext.formatContext() + "-SelectKey")));
        return new KStreamHolder(reKeyed, params.getSchema(), stream.getExecutionKeyFactory().withQueryBuilder(buildContext));
    }

    static interface PartitionByParamsBuilder {
        public <K> PartitionByParams<K> build(LogicalSchema var1, ExecutionKeyFactory<K> var2, List<Expression> var3, KsqlConfig var4, FunctionRegistry var5, ProcessingLogger var6);
    }
}

