/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.TableSuppress;
import io.confluent.ksql.execution.runtime.MaterializedFactory;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.transform.KsValueTransformer;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.SerdeFeatures;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Suppressed;

public final class TableSuppressBuilder {
    private static final String SUPPRESS_OP_NAME = "Suppress";

    public <K> KTableHolder<K> build(KTableHolder<K> table, TableSuppress<K> step, RuntimeBuildContext buildContext, ExecutionKeyFactory<K> executionKeyFactory) {
        return this.build(table, step, buildContext, executionKeyFactory, PhysicalSchema::from, buildContext.getMaterializedFactory());
    }

    @VisibleForTesting
    <K> KTableHolder<K> build(KTableHolder<K> table, TableSuppress<K> step, RuntimeBuildContext buildContext, ExecutionKeyFactory<K> executionKeyFactory, PhysicalSchemaFactory physicalSchemaFactory, MaterializedFactory materializedFactory) {
        PhysicalSchema physicalSchema = physicalSchemaFactory.create(table.getSchema(), step.getInternalFormats().getKeyFeatures(), step.getInternalFormats().getValueFeatures());
        QueryContext queryContext = QueryContext.Stacker.of((QueryContext)step.getProperties().getQueryContext()).push(new String[]{SUPPRESS_OP_NAME}).getQueryContext();
        Serde keySerde = executionKeyFactory.buildKeySerde(step.getInternalFormats().getKeyFormat(), physicalSchema, queryContext);
        Serde valueSerde = buildContext.buildValueSerde(step.getInternalFormats().getValueFormat(), physicalSchema, queryContext);
        Materialized materialized = materializedFactory.create(keySerde, valueSerde);
        long maxBytes = buildContext.getKsqlConfig().getLong("ksql.suppress.buffer.size.bytes");
        Suppressed.StrictBufferConfig strictBufferConfig = maxBytes < 0L ? Suppressed.BufferConfig.unbounded() : Suppressed.BufferConfig.maxBytes((long)maxBytes).shutDownWhenFull();
        KTable suppressed = table.getTable().transformValues(() -> new KsValueTransformer((k, v) -> v), materialized, new String[0]).suppress(Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)strictBufferConfig).withName(SUPPRESS_OP_NAME));
        return table.withTable(suppressed, table.getSchema());
    }

    static interface PhysicalSchemaFactory {
        public PhysicalSchema create(LogicalSchema var1, SerdeFeatures var2, SerdeFeatures var3);
    }
}

