/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.JoinType;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.TableTableJoin;
import io.confluent.ksql.execution.streams.JoinParams;
import io.confluent.ksql.execution.streams.JoinParamsFactory;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.ValueJoiner;

public final class TableTableJoinBuilder {
    private TableTableJoinBuilder() {
    }

    public static <K> KTableHolder<K> build(KTableHolder<K> left, KTableHolder<K> right, TableTableJoin<K> join) {
        LogicalSchema rightSchema;
        LogicalSchema leftSchema;
        if (join.getJoinType().equals((Object)JoinType.RIGHT)) {
            leftSchema = right.getSchema();
            rightSchema = left.getSchema();
        } else {
            leftSchema = left.getSchema();
            rightSchema = right.getSchema();
        }
        JoinParams joinParams = JoinParamsFactory.create(join.getKeyColName(), leftSchema, rightSchema);
        return KTableHolder.unmaterialized((KTable)(switch (join.getJoinType()) {
            case JoinType.INNER -> left.getTable().join(right.getTable(), (ValueJoiner)joinParams.getJoiner());
            case JoinType.LEFT -> left.getTable().leftJoin(right.getTable(), (ValueJoiner)joinParams.getJoiner());
            case JoinType.RIGHT -> right.getTable().leftJoin(left.getTable(), (ValueJoiner)joinParams.getJoiner());
            case JoinType.OUTER -> left.getTable().outerJoin(right.getTable(), (ValueJoiner)joinParams.getJoiner());
            default -> throw new IllegalStateException("invalid join type: " + String.valueOf(join.getJoinType()));
        }), (LogicalSchema)joinParams.getSchema(), (ExecutionKeyFactory)left.getExecutionKeyFactory());
    }
}

