/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.streams.materialization.Locator;
import io.confluent.ksql.execution.streams.materialization.Materialization;
import io.confluent.ksql.execution.streams.materialization.MaterializedTable;
import io.confluent.ksql.execution.streams.materialization.MaterializedWindowedTable;
import io.confluent.ksql.execution.streams.materialization.PullProcessingContext;
import io.confluent.ksql.execution.streams.materialization.Row;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterialization;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterializedTable;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterializedWindowedTable;
import io.confluent.ksql.execution.streams.materialization.TableRow;
import io.confluent.ksql.execution.streams.materialization.WindowedRow;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterializedQueryResult;
import io.confluent.ksql.execution.transform.KsqlProcessingContext;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.ConsistencyUtil;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.streams.query.Position;

class KsqlMaterialization
implements Materialization {
    private final StreamsMaterialization inner;
    private final LogicalSchema schema;
    private final List<Transform> transforms;

    KsqlMaterialization(StreamsMaterialization inner, LogicalSchema schema, List<Transform> transforms) {
        this.inner = Objects.requireNonNull(inner, "table");
        this.schema = Objects.requireNonNull(schema, "schema");
        this.transforms = ImmutableList.copyOf((Collection)Objects.requireNonNull(transforms, "transforms"));
    }

    @Override
    public LogicalSchema schema() {
        return this.schema;
    }

    @Override
    public Locator locator() {
        return this.inner.locator();
    }

    @Override
    public Optional<WindowType> windowType() {
        return this.inner.windowType();
    }

    @Override
    public MaterializedTable nonWindowed() {
        return new KsqlMaterializedTable(this.inner.nonWindowed());
    }

    @Override
    public MaterializedWindowedTable windowed() {
        return new KsqlMaterializedWindowedTable(this.inner.windowed());
    }

    private Optional<GenericRow> filterAndTransform(Object key, GenericRow value, long rowTime) {
        GenericRow intermediate = value;
        for (Transform transform : this.transforms) {
            Optional<GenericRow> result = transform.apply(key, intermediate, new PullProcessingContext(rowTime));
            if (!result.isPresent()) {
                return Optional.empty();
            }
            intermediate = result.get();
        }
        return Optional.of(intermediate);
    }

    private void updateConsistencyVector(Optional<ConsistencyOffsetVector> consistencyVector, Optional<Position> position) {
        if (position.isPresent() && consistencyVector.isPresent()) {
            ConsistencyUtil.updateFromPosition((ConsistencyOffsetVector)consistencyVector.get(), (Position)position.get());
        }
    }

    public static GenericRow getIntermediateRow(TableRow row) {
        GenericKey key = row.key();
        GenericRow value = row.value();
        List keyFields = key.values();
        value.ensureAdditionalCapacity(1 + keyFields.size() + row.window().map(w -> 2).orElse(0));
        value.append((Object)row.rowTime());
        value.appendAll((Collection)keyFields);
        row.window().ifPresent(window -> {
            value.append((Object)window.start().toEpochMilli());
            value.append((Object)window.end().toEpochMilli());
        });
        return value;
    }

    final class KsqlMaterializedTable
    implements MaterializedTable {
        private final StreamsMaterializedTable table;

        KsqlMaterializedTable(StreamsMaterializedTable table) {
            this.table = Objects.requireNonNull(table, "table'");
        }

        @Override
        public Iterator<Row> get(GenericKey key, int partition, Optional<ConsistencyOffsetVector> consistencyVector) {
            Optional<Position> position = consistencyVector.map(offsetVector -> Position.fromMap((Map)offsetVector.getOffsetVector()));
            KsMaterializedQueryResult<Row> result = this.table.get(key, partition, position);
            KsqlMaterialization.this.updateConsistencyVector(consistencyVector, result.getPosition());
            if (KsqlMaterialization.this.transforms.isEmpty()) {
                return result.getRowIterator();
            }
            Iterator<Row> iterator = Streams.stream(result.getRowIterator()).map(row -> KsqlMaterialization.this.filterAndTransform(row.key(), KsqlMaterialization.getIntermediateRow(row), row.rowTime()).map(v -> row.withValue((GenericRow)v, KsqlMaterialization.this.schema()))).filter(Optional::isPresent).map(Optional::get).iterator();
            return iterator;
        }

        @Override
        public Iterator<Row> get(int partition, Optional<ConsistencyOffsetVector> consistencyVector) {
            Optional<Position> position = consistencyVector.map(offsetVector -> Position.fromMap((Map)offsetVector.getOffsetVector()));
            KsMaterializedQueryResult<Row> result = this.table.get(partition, position);
            KsqlMaterialization.this.updateConsistencyVector(consistencyVector, result.getPosition());
            if (KsqlMaterialization.this.transforms.isEmpty()) {
                return result.getRowIterator();
            }
            Iterator<Row> iterator = Streams.stream(result.getRowIterator()).map(row -> KsqlMaterialization.this.filterAndTransform(row.key(), KsqlMaterialization.getIntermediateRow(row), row.rowTime()).map(v -> row.withValue((GenericRow)v, KsqlMaterialization.this.schema()))).filter(Optional::isPresent).map(Optional::get).iterator();
            return iterator;
        }

        @Override
        public Iterator<Row> get(int partition, GenericKey from, GenericKey to, Optional<ConsistencyOffsetVector> consistencyVector) {
            Optional<Position> position = consistencyVector.map(offsetVector -> Position.fromMap((Map)offsetVector.getOffsetVector()));
            KsMaterializedQueryResult<Row> result = this.table.get(partition, from, to, position);
            KsqlMaterialization.this.updateConsistencyVector(consistencyVector, result.getPosition());
            if (KsqlMaterialization.this.transforms.isEmpty()) {
                return result.getRowIterator();
            }
            Iterator<Row> iterator = Streams.stream(result.getRowIterator()).map(row -> KsqlMaterialization.this.filterAndTransform(row.key(), KsqlMaterialization.getIntermediateRow(row), row.rowTime()).map(v -> row.withValue((GenericRow)v, KsqlMaterialization.this.schema()))).filter(Optional::isPresent).map(Optional::get).iterator();
            return iterator;
        }
    }

    final class KsqlMaterializedWindowedTable
    implements MaterializedWindowedTable {
        private final StreamsMaterializedWindowedTable table;

        KsqlMaterializedWindowedTable(StreamsMaterializedWindowedTable table) {
            this.table = Objects.requireNonNull(table, "table'");
        }

        @Override
        public Iterator<WindowedRow> get(GenericKey key, int partition, Range<Instant> windowStart, Range<Instant> windowEnd, Optional<ConsistencyOffsetVector> consistencyVector) {
            Optional<Position> position = consistencyVector.map(offsetVector -> Position.fromMap((Map)offsetVector.getOffsetVector()));
            KsMaterializedQueryResult<WindowedRow> result = this.table.get(key, partition, windowStart, windowEnd, position);
            KsqlMaterialization.this.updateConsistencyVector(consistencyVector, result.getPosition());
            if (KsqlMaterialization.this.transforms.isEmpty()) {
                return result.getRowIterator();
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            while (result.getRowIterator().hasNext()) {
                WindowedRow row = result.getRowIterator().next();
                KsqlMaterialization.this.filterAndTransform(row.windowedKey(), KsqlMaterialization.getIntermediateRow(row), row.rowTime()).ifPresent(v -> builder.add((Object)row.withValue((GenericRow)v, KsqlMaterialization.this.schema())));
            }
            return builder.build().iterator();
        }

        @Override
        public Iterator<WindowedRow> get(int partition, Range<Instant> windowStartBounds, Range<Instant> windowEndBounds, Optional<ConsistencyOffsetVector> consistencyVector) {
            Optional<Position> position = consistencyVector.map(offsetVector -> Position.fromMap((Map)offsetVector.getOffsetVector()));
            KsMaterializedQueryResult<WindowedRow> result = this.table.get(partition, windowStartBounds, windowEndBounds, position);
            KsqlMaterialization.this.updateConsistencyVector(consistencyVector, result.getPosition());
            if (KsqlMaterialization.this.transforms.isEmpty()) {
                return result.getRowIterator();
            }
            Iterator<WindowedRow> iterator = Streams.stream(result.getRowIterator()).map(row -> KsqlMaterialization.this.filterAndTransform(row.windowedKey(), KsqlMaterialization.getIntermediateRow(row), row.rowTime()).map(v -> row.withValue((GenericRow)v, KsqlMaterialization.this.schema()))).filter(Optional::isPresent).map(Optional::get).iterator();
            return iterator;
        }
    }

    static interface Transform {
        public Optional<GenericRow> apply(Object var1, GenericRow var2, KsqlProcessingContext var3);
    }
}

