/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization.ks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.streams.materialization.MaterializationException;
import io.confluent.ksql.execution.streams.materialization.Row;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterializedTable;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterializedQueryResult;
import io.confluent.ksql.execution.streams.materialization.ks.KsStateStore;
import io.confluent.ksql.util.IteratorUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;

class KsMaterializedTable
implements StreamsMaterializedTable {
    private final KsStateStore stateStore;

    KsMaterializedTable(KsStateStore store) {
        this.stateStore = Objects.requireNonNull(store, "store");
    }

    @Override
    public KsMaterializedQueryResult<Row> get(GenericKey key, int partition, Optional<Position> position) {
        try {
            ReadOnlyKeyValueStore store = (ReadOnlyKeyValueStore)this.stateStore.store(QueryableStoreTypes.timestampedKeyValueStore(), partition);
            ValueAndTimestamp row = (ValueAndTimestamp)store.get((Object)key);
            if (row == null) {
                return KsMaterializedQueryResult.rowIterator(Collections.emptyIterator());
            }
            return KsMaterializedQueryResult.rowIterator(ImmutableList.of((Object)Row.of(this.stateStore.schema(), key, (GenericRow)row.value(), row.timestamp())).iterator());
        }
        catch (Exception e) {
            throw new MaterializationException("Failed to get value from materialized table", e);
        }
    }

    @Override
    public KsMaterializedQueryResult<Row> get(int partition, Optional<Position> position) {
        try {
            ReadOnlyKeyValueStore store = (ReadOnlyKeyValueStore)this.stateStore.store(QueryableStoreTypes.timestampedKeyValueStore(), partition);
            KeyValueIterator iterator = store.all();
            return KsMaterializedQueryResult.rowIterator(Streams.stream((Iterator)IteratorUtil.onComplete((Iterator)iterator, () -> ((KeyValueIterator)iterator).close())).map(keyValue -> Row.of(this.stateStore.schema(), (GenericKey)keyValue.key, (GenericRow)((ValueAndTimestamp)keyValue.value).value(), ((ValueAndTimestamp)keyValue.value).timestamp())).iterator());
        }
        catch (Exception e) {
            throw new MaterializationException("Failed to scan materialized table", e);
        }
    }

    @Override
    public KsMaterializedQueryResult<Row> get(int partition, GenericKey from, GenericKey to, Optional<Position> position) {
        try {
            ReadOnlyKeyValueStore store = (ReadOnlyKeyValueStore)this.stateStore.store(QueryableStoreTypes.timestampedKeyValueStore(), partition);
            KeyValueIterator iterator = store.range((Object)from, (Object)to);
            return KsMaterializedQueryResult.rowIterator(Streams.stream((Iterator)IteratorUtil.onComplete((Iterator)iterator, () -> ((KeyValueIterator)iterator).close())).map(keyValue -> Row.of(this.stateStore.schema(), (GenericKey)keyValue.key, (GenericRow)((ValueAndTimestamp)keyValue.value).value(), ((ValueAndTimestamp)keyValue.value).timestamp())).iterator());
        }
        catch (Exception e) {
            throw new MaterializationException("Failed to range scan materialized table", e);
        }
    }
}

