/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization.ks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.streams.materialization.MaterializationException;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterializedWindowedTable;
import io.confluent.ksql.execution.streams.materialization.WindowedRow;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterializedQueryResult;
import io.confluent.ksql.execution.streams.materialization.ks.KsStateStore;
import io.confluent.ksql.execution.streams.materialization.ks.WindowStoreCacheBypass;
import io.confluent.ksql.util.IteratorUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStoreIterator;

class KsMaterializedWindowTable
implements StreamsMaterializedWindowedTable {
    private final KsStateStore stateStore;
    private final Duration windowSize;
    private final WindowStoreCacheBypass.WindowStoreCacheBypassFetcher cacheBypassFetcher;
    private final WindowStoreCacheBypass.WindowStoreCacheBypassFetcherAll cacheBypassFetcherAll;
    private final WindowStoreCacheBypass.WindowStoreCacheBypassFetcherRange cacheBypassFetcherRange;

    KsMaterializedWindowTable(KsStateStore store, Duration windowSize, WindowStoreCacheBypass.WindowStoreCacheBypassFetcher cacheBypassFetcher, WindowStoreCacheBypass.WindowStoreCacheBypassFetcherAll cacheBypassFetcherAll, WindowStoreCacheBypass.WindowStoreCacheBypassFetcherRange cacheBypassFetcherRange) {
        this.stateStore = Objects.requireNonNull(store, "store");
        this.windowSize = Objects.requireNonNull(windowSize, "windowSize");
        this.cacheBypassFetcher = Objects.requireNonNull(cacheBypassFetcher, "cacheBypassFetcher");
        this.cacheBypassFetcherAll = Objects.requireNonNull(cacheBypassFetcherAll, "cacheBypassFetcherAll");
        this.cacheBypassFetcherRange = Objects.requireNonNull(cacheBypassFetcherRange, "cacheBypassFetcherRange");
    }

    @Override
    public KsMaterializedQueryResult<WindowedRow> get(GenericKey key, int partition, Range<Instant> windowStartBounds, Range<Instant> windowEndBounds, Optional<Position> position) {
        KsMaterializedQueryResult<WindowedRow> ksMaterializedQueryResult;
        block9: {
            ReadOnlyWindowStore store = (ReadOnlyWindowStore)this.stateStore.store(QueryableStoreTypes.timestampedWindowStore(), partition);
            Instant lower = this.calculateLowerBound(windowStartBounds, windowEndBounds);
            Instant upper = this.calculateUpperBound(windowStartBounds, windowEndBounds);
            WindowStoreIterator<ValueAndTimestamp<GenericRow>> it = this.cacheBypassFetcher.fetch((ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>>)store, key, lower, upper);
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                while (it.hasNext()) {
                    Instant windowEnd;
                    KeyValue next = (KeyValue)it.next();
                    Instant windowStart = Instant.ofEpochMilli((Long)next.key);
                    if (!windowStartBounds.contains((Comparable)windowStart) || !windowEndBounds.contains((Comparable)(windowEnd = windowStart.plus(this.windowSize)))) continue;
                    TimeWindow window = new TimeWindow(windowStart.toEpochMilli(), windowEnd.toEpochMilli());
                    WindowedRow row = WindowedRow.of(this.stateStore.schema(), (Windowed<GenericKey>)new Windowed((Object)key, (Window)window), (GenericRow)((ValueAndTimestamp)next.value).value(), ((ValueAndTimestamp)next.value).timestamp());
                    builder.add((Object)row);
                }
                ksMaterializedQueryResult = KsMaterializedQueryResult.rowIterator(builder.build().iterator());
                if (it == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (it != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MaterializationException("Failed to get value from materialized table", e);
                }
            }
            it.close();
        }
        return ksMaterializedQueryResult;
    }

    @Override
    public KsMaterializedQueryResult<WindowedRow> get(int partition, Range<Instant> windowStartBounds, Range<Instant> windowEndBounds, Optional<Position> position) {
        try {
            ReadOnlyWindowStore store = (ReadOnlyWindowStore)this.stateStore.store(QueryableStoreTypes.timestampedWindowStore(), partition);
            Instant lower = this.calculateLowerBound(windowStartBounds, windowEndBounds);
            Instant upper = this.calculateUpperBound(windowStartBounds, windowEndBounds);
            KeyValueIterator<Windowed<GenericKey>, ValueAndTimestamp<GenericRow>> iterator = this.cacheBypassFetcherAll.fetchAll((ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>>)store, lower, upper);
            return KsMaterializedQueryResult.rowIterator(Streams.stream((Iterator)IteratorUtil.onComplete(iterator, () -> iterator.close())).map(next -> {
                Instant windowStart = ((Windowed)next.key).window().startTime();
                if (!windowStartBounds.contains((Comparable)windowStart)) {
                    return null;
                }
                Instant windowEnd = ((Windowed)next.key).window().endTime();
                if (!windowEndBounds.contains((Comparable)windowEnd)) {
                    return null;
                }
                TimeWindow window = new TimeWindow(windowStart.toEpochMilli(), windowEnd.toEpochMilli());
                WindowedRow row = WindowedRow.of(this.stateStore.schema(), (Windowed<GenericKey>)new Windowed((Object)((GenericKey)((Windowed)next.key).key()), (Window)window), (GenericRow)((ValueAndTimestamp)next.value).value(), ((ValueAndTimestamp)next.value).timestamp());
                return row;
            }).filter(Objects::nonNull).iterator());
        }
        catch (Exception e) {
            throw new MaterializationException("Failed to scan materialized table", e);
        }
    }

    private Instant calculateUpperBound(Range<Instant> windowStartBounds, Range<Instant> windowEndBounds) {
        Instant start = windowStartBounds.hasUpperBound() ? (Instant)windowStartBounds.upperEndpoint() : Instant.ofEpochMilli(Long.MAX_VALUE);
        Instant end = windowEndBounds.hasUpperBound() ? ((Instant)windowEndBounds.upperEndpoint()).minus(this.windowSize) : Instant.ofEpochMilli(Long.MAX_VALUE);
        return start.compareTo(end) < 0 ? start : end;
    }

    private Instant calculateLowerBound(Range<Instant> windowStartBounds, Range<Instant> windowEndBounds) {
        Instant start = windowStartBounds.hasLowerBound() ? (Instant)windowStartBounds.lowerEndpoint() : Instant.ofEpochMilli(0L);
        Instant end = windowEndBounds.hasLowerBound() ? ((Instant)windowEndBounds.lowerEndpoint()).minus(this.windowSize) : Instant.ofEpochMilli(0L);
        return start.compareTo(end) < 0 ? end : start;
    }
}

