/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization.ks;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.execution.streams.materialization.MaterializationException;
import io.confluent.ksql.execution.streams.materialization.NotRunningException;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Objects;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.processor.internals.namedtopology.KafkaStreamsNamedTopologyWrapper;
import org.apache.kafka.streams.processor.internals.namedtopology.NamedTopologyStoreQueryParameters;
import org.apache.kafka.streams.state.QueryableStoreType;

class KsStateStore {
    private final String stateStoreName;
    private final KafkaStreams kafkaStreams;
    private final LogicalSchema schema;
    private final KsqlConfig ksqlConfig;
    private final String queryId;

    @VisibleForTesting
    KsStateStore(String stateStoreName, KafkaStreams kafkaStreams, LogicalSchema schema, KsqlConfig ksqlConfig, String queryId) {
        this.kafkaStreams = Objects.requireNonNull(kafkaStreams, "kafkaStreams");
        this.stateStoreName = Objects.requireNonNull(stateStoreName, "stateStoreName");
        this.schema = Objects.requireNonNull(schema, "schema");
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.queryId = Objects.requireNonNull(queryId, "queryId");
    }

    LogicalSchema schema() {
        return this.schema;
    }

    String getStateStoreName() {
        return this.stateStoreName;
    }

    KafkaStreams getKafkaStreams() {
        return this.kafkaStreams;
    }

    KsqlConfig getKsqlConfig() {
        return this.ksqlConfig;
    }

    <T> T store(QueryableStoreType<T> queryableStoreType, int partition) {
        try {
            boolean enableStaleStores = this.ksqlConfig.getBoolean("ksql.query.pull.enable.standby.reads");
            boolean sharedRuntime = this.kafkaStreams instanceof KafkaStreamsNamedTopologyWrapper;
            StoreQueryParameters parameters = sharedRuntime ? NamedTopologyStoreQueryParameters.fromNamedTopologyAndStoreNameAndType((String)this.queryId, (String)this.stateStoreName, queryableStoreType).withPartition(Integer.valueOf(partition)) : StoreQueryParameters.fromNameAndType((String)this.stateStoreName, queryableStoreType).withPartition(Integer.valueOf(partition));
            return (T)(enableStaleStores ? this.kafkaStreams.store(parameters.enableStaleStores()) : this.kafkaStreams.store(parameters));
        }
        catch (Exception e) {
            KafkaStreams.State state = this.kafkaStreams.state();
            if (state != KafkaStreams.State.RUNNING) {
                throw new NotRunningException("The query was not in a running state. state: " + String.valueOf(state));
            }
            throw new MaterializationException("State store currently unavailable: " + this.stateStoreName, e);
        }
    }
}

