/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.process;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import java.util.Objects;
import org.apache.kafka.streams.processor.api.FixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorContext;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;

public class KsFixedKeyProcessor<K, R>
implements FixedKeyProcessor<K, GenericRow, R> {
    private final KsqlTransformer<K, R> delegate;
    private FixedKeyProcessorContext<K, R> processorContext;

    public KsFixedKeyProcessor(KsqlTransformer<K, R> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.processorContext = null;
    }

    public void init(FixedKeyProcessorContext<K, R> context) {
        this.processorContext = context;
    }

    public void process(FixedKeyRecord<K, GenericRow> record) {
        Object key = record.key();
        GenericRow value = (GenericRow)record.value();
        Object result = this.delegate.transform(key, value);
        this.processorContext.forward(record.withValue(result));
    }
}

