/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.process;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import java.util.Objects;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;

public class KsProcessor<KInT, KOutT>
implements Processor<KInT, GenericRow, KOutT, GenericRow> {
    private ProcessorContext<KOutT, GenericRow> processorContext;
    private final KsqlTransformer<KInT, KOutT> keyDelegate;
    private final KsqlTransformer<KInT, GenericRow> valueDelegate;

    public KsProcessor(KsqlTransformer<KInT, KOutT> keyDelegate, KsqlTransformer<KInT, GenericRow> valueDelegate) {
        this.keyDelegate = Objects.requireNonNull(keyDelegate, "keyDelegate");
        this.valueDelegate = Objects.requireNonNull(valueDelegate, "valueDelegate");
    }

    public void init(ProcessorContext<KOutT, GenericRow> processContext) {
        this.processorContext = processContext;
    }

    public void process(Record<KInT, GenericRow> record) {
        Object key = record.key();
        GenericRow value = (GenericRow)record.value();
        Record newRecord = new Record(this.keyDelegate.transform(key, value), (Object)((GenericRow)this.valueDelegate.transform(key, value)), record.timestamp(), record.headers());
        this.processorContext.forward(newRecord);
    }
}

