/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.jwt;

import io.confluent.kafka.clients.plugins.auth.jwt.CloseableVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.PublicKeyJwks;
import java.security.Key;
import java.util.List;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public final class PublicKeyVerificationKeyResolver
implements CloseableVerificationKeyResolver {
    private final JwksVerificationKeyResolver delegate;

    public PublicKeyVerificationKeyResolver(PublicKeyJwks jwks) {
        this(jwks.getJsonWebKeys());
    }

    public PublicKeyVerificationKeyResolver(List<JsonWebKey> jwks) {
        this.delegate = new JwksVerificationKeyResolver(jwks);
        this.delegate.setDisambiguateWithVerifySignature(true);
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        return this.delegate.resolveKey(jws, nestingContext);
    }

    @Override
    public void close() {
    }
}

