/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.signature.EcdsaParameters;
import com.google.crypto.tink.signature.EcdsaPrivateKey;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EcdsaVerifyJce;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.SubtleUtil;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.EllipticCurve;
import java.util.List;

@Immutable
public final class EcdsaSignJce
implements PublicKeySign {
    public static final TinkFipsUtil.AlgorithmFipsCompatibility FIPS = TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;
    private final ECPrivateKey privateKey;
    private final String signatureAlgorithm;
    private final EllipticCurves.EcdsaEncoding encoding;
    private final byte[] outputPrefix;
    private final byte[] messageSuffix;

    private EcdsaSignJce(ECPrivateKey priv, Enums.HashType hash, EllipticCurves.EcdsaEncoding encoding, byte[] outputPrefix, byte[] messageSuffix) throws GeneralSecurityException {
        if (!FIPS.isCompatible()) {
            throw new GeneralSecurityException("Can not use ECDSA in FIPS-mode, as BoringCrypto is not available.");
        }
        this.privateKey = priv;
        this.signatureAlgorithm = SubtleUtil.toEcdsaAlgo(hash);
        this.encoding = encoding;
        this.outputPrefix = outputPrefix;
        this.messageSuffix = messageSuffix;
    }

    public EcdsaSignJce(ECPrivateKey priv, Enums.HashType hash, EllipticCurves.EcdsaEncoding encoding) throws GeneralSecurityException {
        this(priv, hash, encoding, new byte[0], new byte[0]);
    }

    @AccessesPartialKey
    public static PublicKeySign create(EcdsaPrivateKey key) throws GeneralSecurityException {
        byte[] byArray;
        Enums.HashType hashType = EcdsaVerifyJce.HASH_TYPE_CONVERTER.toProtoEnum(key.getParameters().getHashType());
        EllipticCurves.EcdsaEncoding ecdsaEncoding = EcdsaVerifyJce.ENCODING_CONVERTER.toProtoEnum(key.getParameters().getSignatureEncoding());
        EllipticCurves.CurveType curveType = EcdsaVerifyJce.CURVE_TYPE_CONVERTER.toProtoEnum(key.getParameters().getCurveType());
        ECPrivateKey privateKey = EllipticCurves.getEcPrivateKey(curveType, key.getPrivateValue().getBigInteger(InsecureSecretKeyAccess.get()).toByteArray());
        byte[] byArray2 = key.getOutputPrefix().toByteArray();
        if (key.getParameters().getVariant().equals(EcdsaParameters.Variant.LEGACY)) {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        } else {
            byArray = new byte[]{};
        }
        EcdsaSignJce signer = new EcdsaSignJce(privateKey, hashType, ecdsaEncoding, byArray2, byArray);
        PublicKeyVerify verify = EcdsaVerifyJce.create(key.getPublicKey());
        try {
            verify.verify(signer.sign(new byte[]{1, 2, 3}), new byte[]{1, 2, 3});
        }
        catch (GeneralSecurityException e) {
            throw new GeneralSecurityException("ECDSA signing with private key followed by verifying with public key failed. The key may be corrupted.", e);
        }
        return signer;
    }

    private byte[] noPrefixSign(byte[] data) throws GeneralSecurityException {
        List<Provider> preferredProviders = EngineFactory.toProviderList("GmsCore_OpenSSL", "AndroidOpenSSL", "Conscrypt");
        Signature signer = EngineFactory.SIGNATURE.getInstance(this.signatureAlgorithm, preferredProviders);
        signer.initSign(this.privateKey);
        signer.update(data);
        byte[] signature = signer.sign();
        if (this.encoding == EllipticCurves.EcdsaEncoding.IEEE_P1363) {
            EllipticCurve curve = this.privateKey.getParams().getCurve();
            signature = EllipticCurves.ecdsaDer2Ieee(signature, 2 * EllipticCurves.fieldSizeInBytes(curve));
        }
        return signature;
    }

    @Override
    public byte[] sign(byte[] data) throws GeneralSecurityException {
        byte[] signature = this.messageSuffix.length == 0 ? this.noPrefixSign(data) : this.noPrefixSign(Bytes.concat(data, this.messageSuffix));
        if (this.outputPrefix.length == 0) {
            return signature;
        }
        return Bytes.concat(this.outputPrefix, signature);
    }
}

