/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class DeletedKeyItem
implements JsonSerializable<DeletedKeyItem> {
    private String kid;
    private KeyAttributes attributes;
    private Map<String, String> tags;
    private Boolean managed;
    private String recoveryId;
    private Long scheduledPurgeDate;
    private Long deletedDate;

    private DeletedKeyItem() {
    }

    public String getKid() {
        return this.kid;
    }

    public KeyAttributes getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kid", this.kid);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    public static DeletedKeyItem fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedKeyItem)jsonReader.readObject(reader -> {
            DeletedKeyItem deserializedDeletedKeyItem = new DeletedKeyItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kid".equals(fieldName)) {
                    deserializedDeletedKeyItem.kid = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedDeletedKeyItem.attributes = KeyAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDeletedKeyItem.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedDeletedKeyItem.managed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedKeyItem.recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedKeyItem.scheduledPurgeDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedKeyItem.deletedDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedKeyItem;
        });
    }
}

