/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class KeyOperationResult
implements JsonSerializable<KeyOperationResult> {
    private String kid;
    private Base64Url result;
    private Base64Url iv;
    private Base64Url authenticationTag;
    private Base64Url additionalAuthenticatedData;

    private KeyOperationResult() {
    }

    public String getKid() {
        return this.kid;
    }

    public byte[] getResult() {
        if (this.result == null) {
            return null;
        }
        return this.result.decodedBytes();
    }

    public byte[] getIv() {
        if (this.iv == null) {
            return null;
        }
        return this.iv.decodedBytes();
    }

    public byte[] getAuthenticationTag() {
        if (this.authenticationTag == null) {
            return null;
        }
        return this.authenticationTag.decodedBytes();
    }

    public byte[] getAdditionalAuthenticatedData() {
        if (this.additionalAuthenticatedData == null) {
            return null;
        }
        return this.additionalAuthenticatedData.decodedBytes();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static KeyOperationResult fromJson(JsonReader jsonReader) throws IOException {
        return (KeyOperationResult)jsonReader.readObject(reader -> {
            KeyOperationResult deserializedKeyOperationResult = new KeyOperationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kid".equals(fieldName)) {
                    deserializedKeyOperationResult.kid = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedKeyOperationResult.result = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("iv".equals(fieldName)) {
                    deserializedKeyOperationResult.iv = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("tag".equals(fieldName)) {
                    deserializedKeyOperationResult.authenticationTag = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("aad".equals(fieldName)) {
                    deserializedKeyOperationResult.additionalAuthenticatedData = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyOperationResult;
        });
    }
}

