/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import java.util.Arrays;

public enum E2EChecksumProtectedObjectType {
    SEGMENT("segment"),
    OFFSET_INDEX("offset-index"),
    TIMESTAMP_INDEX("timestamp-index"),
    TRANSACTION_INDEX("transaction-index"),
    PRODUCER_STATE("producer-state"),
    EPOCH_STATE("epoch-state"),
    TIER_STATE_SNAPSHOT("tier-state-snapshot"),
    LIFECYCLE_MANAGER_STATE("lifecycle-manager-state"),
    BACKUP_OBJECTS_LIST("bkp-list"),
    HEALTH_CHECK("health"),
    TIER_PARTITION_STATE_METADATA_SNAPSHOT("tier-partition-state-metadata-snapshot"),
    TIER_TOPIC_SNAPSHOT("tier-topic-snapshot"),
    DA_OFFSET_MAP("da-offset-map"),
    KRAFT_SNAPSHOT("kraft-checkpoint"),
    SEGMENT_WITH_METADATA("segment-with-metadata"),
    FILE_TIER_PARTITION_STATE_UPLOAD("tier-partition-state-upload"),
    TIER_RECOVERY_METADATA_UPLOAD("tier-recovery-metadata-upload"),
    TIER_OFFSETS_UPLOAD("tier-offsets-upload"),
    TIER_TOPIC_HEAD_DATA_LOSS_REPORT("tier-topic-head-data-loss-report");

    private final String suffix;

    private E2EChecksumProtectedObjectType(String suffix) {
        this.suffix = suffix;
    }

    public static E2EChecksumProtectedObjectType fromSuffix(String suffix) {
        for (E2EChecksumProtectedObjectType f : E2EChecksumProtectedObjectType.values()) {
            if (!f.suffix.equals(suffix)) continue;
            return f;
        }
        throw new IllegalArgumentException("No enum with value " + suffix + " found");
    }

    public static String[] getAllValues() {
        return (String[])Arrays.stream(E2EChecksumProtectedObjectType.values()).map(E2EChecksumProtectedObjectType::suffix).toArray(String[]::new);
    }

    public boolean shouldCalculateBeforeUpload() {
        return this.equals((Object)TIER_PARTITION_STATE_METADATA_SNAPSHOT) || this.equals((Object)TIER_STATE_SNAPSHOT) || this.equals((Object)KRAFT_SNAPSHOT);
    }

    public String suffix() {
        return this.suffix;
    }
}

