/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.TreeMap;
import kafka.cluster.EndPoint;
import kafka.server.KafkaConfig;
import kafka.tools.TerseFailure;
import kafka.utils.Logging;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.metadata.storage.Formatter;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.raft.DynamicVoters;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map;
import scala.collection.mutable.TreeSet;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class StorageTool$
implements Logging {
    public static final StorageTool$ MODULE$ = new StorageTool$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode;
        None$ message = None$.MODULE$;
        try {
            exitCode = this.execute(args, System.out);
        }
        catch (FormatterException e) {
            exitCode = 1;
            message = new Some((Object)e.getMessage());
        }
        catch (TerseFailure e) {
            exitCode = 1;
            message = new Some((Object)e.getMessage());
        }
        message.foreach((Function1 & Serializable)x$1 -> {
            System.err.println(x$1);
            return BoxedUnit.UNIT;
        });
        Exit.exit((int)exitCode, (String)((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public int execute(String[] args, PrintStream printStream) {
        Namespace namespace;
        try {
            namespace = this.parseArguments(args);
        }
        catch (HelpScreenException helpScreenException) {
            return 0;
        }
        catch (ArgumentParserException e) {
            e.getParser().handleError(e);
            return 1;
        }
        Namespace namespace2 = namespace;
        String command = namespace2.getString("command");
        Option config = Option$.MODULE$.apply((Object)namespace2.getString("config")).flatMap((Function1 & Serializable)p -> new Some((Object)new KafkaConfig(Utils.loadProps((String)p, null))));
        switch (command == null ? 0 : command.hashCode()) {
            case -1268779017: {
                if (!"format".equals(command)) break;
                this.runFormatCommand(namespace2, (KafkaConfig)config.get(), printStream);
                return 0;
            }
            case -1176328544: {
                if (!"feature-dependencies".equals(command)) break;
                this.runFeatureDependenciesCommand(namespace2, printStream, Feature.PRODUCTION_FEATURES);
                return 0;
            }
            case -745688443: {
                if (!"random-uuid".equals(command)) break;
                printStream.println(Uuid.randomUuid());
                return 0;
            }
            case 3237038: {
                if (!"info".equals(command)) break;
                Seq<String> directories = this.configToLogDirectories((KafkaConfig)config.get());
                return this.infoCommand(printStream, ((KafkaConfig)config.get()).processRoles().nonEmpty(), directories);
            }
            case 1515700441: {
                if (!"version-mapping".equals(command)) break;
                this.runVersionMappingCommand(namespace2, printStream, Feature.PRODUCTION_FEATURES);
                return 0;
            }
        }
        throw new RuntimeException("Unknown command " + command);
    }

    public void runFormatCommand(Namespace namespace, KafkaConfig config, PrintStream printStream) {
        if (config.processRoles().isEmpty()) {
            throw new TerseFailure("The kafka configuration file appears to be for a legacy cluster. Formatting is only supported for clusters in KRaft mode.");
        }
        Formatter formatter = new Formatter().setPrintStream(printStream).setNodeId(config.nodeId()).setClusterId(namespace.getString("cluster_id")).setUnstableFeatureVersionsEnabled(Predef$.MODULE$.Boolean2boolean(config.unstableFeatureVersionsEnabled())).setIgnoreFormatted(Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("ignore_formatted"))).setControllerListenerName((String)config.controllerListenerNames().head()).setMetadataLogDirectory(config.metadataLogDir());
        Option$.MODULE$.apply((Object)namespace.getString("release_version")).foreach((Function1 & Serializable)releaseVersion -> formatter.setReleaseVersion(MetadataVersion.fromVersionString((String)releaseVersion)));
        Option$.MODULE$.apply((Object)namespace.getList("feature")).foreach((Function1 & Serializable)x$1 -> {
            StorageTool$.$anonfun$runFormatCommand$2(formatter, x$1);
            return BoxedUnit.UNIT;
        });
        String initialControllers = namespace.getString("initial_controllers");
        Boolean isStandalone = namespace.getBoolean("standalone");
        boolean staticVotersEmpty = config.quorumConfig().voters().isEmpty();
        formatter.setHasDynamicQuorum(staticVotersEmpty);
        if (!staticVotersEmpty && (Option$.MODULE$.apply((Object)initialControllers).isDefined() || Predef$.MODULE$.Boolean2boolean(isStandalone))) {
            throw new TerseFailure("You cannot specify controller.quorum.voters and format the node with --initial-controllers or --standalone. If you want to use dynamic quorum, please remove controller.quorum.voters and specify controller.quorum.bootstrap.servers instead.");
        }
        Option$.MODULE$.apply((Object)initialControllers).foreach((Function1 & Serializable)v -> formatter.setInitialControllers(DynamicVoters.parse((String)v)));
        if (Predef$.MODULE$.Boolean2boolean(isStandalone)) {
            formatter.setInitialControllers(this.createStandaloneDynamicVoters(config));
        }
        if (!Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("no_initial_controllers")) && config.processRoles().contains((Object)ProcessRole.ControllerRole) && staticVotersEmpty && formatter.initialVoters().isEmpty()) {
            throw new TerseFailure("Because controller.quorum.voters is not set on this controller, you must specify one of the following: --standalone, --initial-controllers, or --no-initial-controllers.");
        }
        Option$.MODULE$.apply((Object)namespace.getList("add_scram")).foreach((Function1 & Serializable)scramArgs -> formatter.setScramArguments(scramArgs));
        this.configToLogDirectories(config).foreach((Function1 & Serializable)x$2 -> formatter.addDirectory(x$2));
        formatter.run();
    }

    public void runVersionMappingCommand(Namespace namespace, PrintStream printStream, java.util.List<Feature> validFeatures) {
        String releaseVersion = (String)Option$.MODULE$.apply((Object)namespace.getString("release_version")).getOrElse((Function0 & Serializable)() -> MetadataVersion.LATEST_PRODUCTION.toString());
        try {
            MetadataVersion metadataVersion = MetadataVersion.fromVersionString((String)releaseVersion);
            short metadataVersionLevel = metadataVersion.featureLevel();
            printStream.print(StringOps$.MODULE$.format$extension("metadata.version=%d (%s)%n", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)metadataVersionLevel), releaseVersion})));
            CollectionConverters$.MODULE$.ListHasAsScala(validFeatures).asScala().foreach((Function1 & Serializable)feature -> {
                StorageTool$.$anonfun$runVersionMappingCommand$2(metadataVersion, printStream, feature);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TerseFailure("Unknown release version '" + releaseVersion + "'. Supported versions are: " + MetadataVersion.MINIMUM_VERSION.version() + " to " + MetadataVersion.LATEST_PRODUCTION.version());
        }
    }

    public void runFeatureDependenciesCommand(Namespace namespace, PrintStream printStream, java.util.List<Feature> validFeatures) {
        ((List)Option$.MODULE$.apply((Object)namespace.getList("feature")).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toList()).getOrElse((Function0 & Serializable)() -> package$.MODULE$.List().empty())).foreach((Function1 & Serializable)featureArg -> {
            void var5_5;
            short s;
            void var6_6;
            Object object;
            block15: {
                String[] stringArray;
                block14: {
                    stringArray = featureArg.split("=");
                    if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray))) break block14;
                    new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object));
                    if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) break block15;
                }
                throw new MatchError((Object)stringArray);
            }
            String featureName = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String versionStr = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            try {
                s = StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString((String)var6_6));
            }
            catch (NumberFormatException numberFormatException) {
                throw new TerseFailure("Invalid version format: " + (String)var6_6 + " for feature " + (String)var5_5);
            }
            short featureLevel = s;
            void v2 = var5_5;
            String string = "metadata.version";
            if (v2 != null && v2.equals(string)) {
                MetadataVersion metadataVersion;
                try {
                    metadataVersion = MetadataVersion.fromFeatureLevel((short)featureLevel);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new TerseFailure("Unknown metadata.version " + featureLevel);
                }
                MetadataVersion metadataVersion2 = metadataVersion;
                return printStream.printf("%s=%d (%s) has no dependencies.%n", var5_5, BoxesRunTime.boxToShort((short)featureLevel), metadataVersion2.version());
            }
            Option option = CollectionConverters$.MODULE$.ListHasAsScala(validFeatures).asScala().find(arg_0 -> StorageTool$.$anonfun$runFeatureDependenciesCommand$4$adapted((String)var5_5, arg_0));
            if (option instanceof Some) {
                FeatureVersion featureVersion;
                try {
                    featureVersion = ((Feature)((Some)option).value()).fromFeatureLevel(featureLevel, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new TerseFailure("Feature level " + featureLevel + " is not supported for feature " + (String)var5_5);
                }
                FeatureVersion featureVersion2 = featureVersion;
                Map dependencies = CollectionConverters$.MODULE$.MapHasAsScala(featureVersion2.dependencies()).asScala();
                if (dependencies.isEmpty()) {
                    return printStream.printf("%s=%d has no dependencies.%n", var5_5, BoxesRunTime.boxToShort((short)featureLevel));
                }
                printStream.printf("%s=%d requires:%n", var5_5, BoxesRunTime.boxToShort((short)featureLevel));
                dependencies.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)StorageTool$.$anonfun$runFeatureDependenciesCommand$5(check$ifrefutable$1))).foreach((Function1 & Serializable)x$6 -> {
                    StorageTool$.$anonfun$runFeatureDependenciesCommand$6(printStream, x$6);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                throw new TerseFailure("Unknown feature: " + (String)var5_5);
            }
            throw new MatchError((Object)option);
        });
    }

    public DynamicVoters createStandaloneDynamicVoters(KafkaConfig config) {
        if (!config.processRoles().contains((Object)ProcessRole.ControllerRole)) {
            throw new TerseFailure("You can only use --standalone on a controller.");
        }
        if (config.effectiveAdvertisedControllerListeners().isEmpty()) {
            throw new RuntimeException("No controller listeners found.");
        }
        EndPoint listener = (EndPoint)config.effectiveAdvertisedControllerListeners().head();
        String host = listener.host() == null ? "localhost" : listener.host();
        return DynamicVoters.parse((String)(config.nodeId() + "@" + host + ":" + listener.port() + ":" + Uuid.randomUuid()));
    }

    public Namespace parseArguments(String[] args) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"kafka-storage", (boolean)true, (String)"-", (String)"@").description("The Kafka storage tool.");
        Subparsers subparsers = parser.addSubparsers().dest("command");
        this.addInfoParser(subparsers);
        this.addFormatParser(subparsers);
        this.addVersionMappingParser(subparsers);
        this.addFeatureDependenciesParser(subparsers);
        this.addRandomUuidParser(subparsers);
        return parser.parseArgs(args);
    }

    private void addInfoParser(Subparsers subparsers) {
        Subparser infoParser = subparsers.addParser("info").help("Get information about the Kafka log directories on this node.");
        this.addConfigArguments(infoParser);
    }

    private void addFormatParser(Subparsers subparsers) {
        Subparser formatParser = subparsers.addParser("format").help("Format the Kafka log directories on this node.");
        this.addConfigArguments(formatParser);
        formatParser.addArgument(new String[]{"--cluster-id", "-t"}).action((ArgumentAction)Arguments.store()).required(true).help("The cluster ID to use.");
        formatParser.addArgument(new String[]{"--add-scram", "-S"}).action((ArgumentAction)Arguments.append()).help(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A SCRAM_CREDENTIAL to add to the __cluster_metadata log e.g.\n              |'SCRAM-SHA-256=[name=alice,password=alice-secret]'\n              |'SCRAM-SHA-512=[name=alice,iterations=8192,salt=\"N3E=\",saltedpassword=\"YCE=\"]'")));
        formatParser.addArgument(new String[]{"--ignore-formatted", "-g"}).help("When this option is passed, the format command will skip over already formatted directories rather than failing.").action((ArgumentAction)Arguments.storeTrue());
        formatParser.addArgument(new String[]{"--release-version", "-r"}).action((ArgumentAction)Arguments.store()).help("The release version to use for the initial feature settings. The minimum is " + MetadataVersion.MINIMUM_VERSION + "; the default is " + MetadataVersion.LATEST_PRODUCTION);
        formatParser.addArgument(new String[]{"--feature", "-f"}).help("The setting to use for a specific feature, in feature=level format. For example: `kraft.version=1`.").action((ArgumentAction)Arguments.append());
        MutuallyExclusiveGroup reconfigurableQuorumOptions = formatParser.addMutuallyExclusiveGroup();
        reconfigurableQuorumOptions.addArgument(new String[]{"--standalone", "-s"}).help("Used to initialize a controller as a single-node dynamic quorum. When setting this flag, the controller.quorum.voters config must not be set, and controller.quorum.bootstrap.servers is set instead.").action((ArgumentAction)Arguments.storeTrue());
        reconfigurableQuorumOptions.addArgument(new String[]{"--no-initial-controllers", "-N"}).help("Used to initialize a server without specifying a dynamic quorum. When setting this flag, the controller.quorum.voters config should not be set, and controller.quorum.bootstrap.servers is set instead.").action((ArgumentAction)Arguments.storeTrue());
        reconfigurableQuorumOptions.addArgument(new String[]{"--initial-controllers", "-I"}).help("Used to initialize a server with the specified dynamic quorum. The argument is a comma-separated list of id@hostname:port:directory. The same values must be used to format all nodes. For example:\n0@example.com:8082:JEXY6aqzQY-32P5TStzaFg,1@example.com:8083:MvDxzVmcRsaTz33bUuRU6A,2@example.com:8084:07R5amHmR32VDA6jHkGbTA\n. When setting this flag, the controller.quorum.voters config must not be set, and controller.quorum.bootstrap.servers is set instead.").action((ArgumentAction)Arguments.store());
    }

    private void addVersionMappingParser(Subparsers subparsers) {
        subparsers.addParser("version-mapping").help("Look up the corresponding features for a given metadata version. Using the command with no --release-version  argument will return the mapping for the latest stable metadata version").addArgument(new String[]{"--release-version", "-r"}).action((ArgumentAction)Arguments.store()).help("The release version to use for the corresponding feature mapping. The minimum is " + MetadataVersion.MINIMUM_VERSION + "; the default is " + MetadataVersion.LATEST_PRODUCTION);
    }

    private void addFeatureDependenciesParser(Subparsers subparsers) {
        subparsers.addParser("feature-dependencies").help("Look up dependencies for a given feature version. If the feature is not known or the version not yet defined, an error is thrown. Multiple features can be specified.").addArgument(new String[]{"--feature", "-f"}).required(true).help("The features and their versions to look up dependencies for, in feature=version format. For example: `metadata.version=5`.").action((ArgumentAction)Arguments.append());
    }

    private void addRandomUuidParser(Subparsers subparsers) {
        subparsers.addParser("random-uuid").help("Print a random UUID.");
    }

    private void addConfigArguments(Subparser parser) {
        parser.addArgument(new String[]{"--config", "-c"}).action((ArgumentAction)Arguments.store()).required(true).help("The Kafka configuration file to use.");
    }

    public Seq<String> configToLogDirectories(KafkaConfig config) {
        TreeSet directories = new TreeSet((Ordering)Ordering.String$.MODULE$);
        directories.$plus$plus$eq(config.logDirs());
        Option$.MODULE$.apply((Object)config.metadataLogDir()).foreach((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)directories.add((Object)elem)));
        return directories.toSeq();
    }

    public int infoCommand(PrintStream stream, boolean kraftMode, Seq<String> directories) {
        ArrayBuffer problems = new ArrayBuffer();
        ArrayBuffer foundDirectories = new ArrayBuffer();
        ObjectRef prevMetadata = ObjectRef.create((Object)None$.MODULE$);
        ((IterableOnceOps)directories.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)directory -> {
            Growable growable;
            block8: {
                Path directoryPath = Paths.get(directory, new String[0]);
                if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
                    if (!Files.exists(directoryPath, new LinkOption[0])) {
                        return problems.$plus$eq((Object)(directoryPath + " does not exist"));
                    }
                    return problems.$plus$eq((Object)(directoryPath + " is not a directory"));
                }
                foundDirectories.$plus$eq((Object)((Object)directoryPath).toString());
                Path metaPath = directoryPath.resolve("meta.properties");
                if (!Files.exists(metaPath, new LinkOption[0])) {
                    return problems.$plus$eq((Object)(directoryPath + " is not formatted."));
                }
                Properties properties = PropertiesUtils.readPropertiesFile((String)((Object)metaPath).toString());
                try {
                    MetaProperties curMetadata = new MetaProperties.Builder(properties).build();
                    if (((Option)prevMetadata$1.elem).isEmpty()) {
                        prevMetadata$1.elem = new Some((Object)curMetadata);
                        growable = BoxedUnit.UNIT;
                        break block8;
                    }
                    if (!((MetaProperties)((Option)prevMetadata$1.elem).get()).clusterId().equals(curMetadata.clusterId())) {
                        growable = problems.$plus$eq((Object)"Mismatched cluster IDs between storage directories.");
                        break block8;
                    }
                    if (!((MetaProperties)((Option)prevMetadata$1.elem).get()).nodeId().equals(curMetadata.nodeId())) {
                        growable = problems.$plus$eq((Object)"Mismatched node IDs between storage directories.");
                        break block8;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    growable = problems.$plus$eq((Object)("Error loading " + metaPath + ": " + e.getMessage()));
                }
            }
            return growable;
        });
        ((Option)prevMetadata.elem).foreach((Function1 & Serializable)prev -> {
            if (kraftMode) {
                if (prev.version().equals((Object)MetaPropertiesVersion.V0)) {
                    return problems.$plus$eq((Object)"The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.");
                }
                return BoxedUnit.UNIT;
            }
            if (prev.version().equals((Object)MetaPropertiesVersion.V1)) {
                return problems.$plus$eq((Object)"The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.");
            }
            return BoxedUnit.UNIT;
        });
        if (directories.isEmpty()) {
            stream.println("No directories specified.");
            return 0;
        }
        if (foundDirectories.nonEmpty()) {
            if (foundDirectories.size() == 1) {
                stream.println("Found log directory:");
            } else {
                stream.println("Found log directories:");
            }
            foundDirectories.foreach((Function1 & Serializable)d -> {
                stream.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("  %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{d})));
                return BoxedUnit.UNIT;
            });
            stream.println("");
        }
        ((Option)prevMetadata.elem).foreach((Function1 & Serializable)prev -> {
            StorageTool$.$anonfun$infoCommand$4(stream, prev);
            return BoxedUnit.UNIT;
        });
        if (problems.nonEmpty()) {
            if (problems.size() == 1) {
                stream.println("Found problem:");
            } else {
                stream.println("Found problems:");
            }
            problems.foreach((Function1 & Serializable)d -> {
                stream.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("  %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{d})));
                return BoxedUnit.UNIT;
            });
            stream.println("");
            return 1;
        }
        return 0;
    }

    public Tuple2<String, Short> parseNameAndLevel(String input) {
        int equalsIndex = input.indexOf("=");
        if (equalsIndex < 0) {
            throw new RuntimeException("Can't parse feature=level string " + input + ": equals sign not found.");
        }
        String name = input.substring(0, equalsIndex).trim();
        String levelString = input.substring(equalsIndex + 1).trim();
        try {
            return new Tuple2((Object)name, (Object)Predef$.MODULE$.short2Short(StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(levelString))));
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Can't parse feature=level string " + input + ": unable to parse " + levelString + " as a short.");
        }
    }

    public scala.collection.immutable.Map<String, Short> featureNamesAndLevels(java.util.List<String> features) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(features).asScala().map((Function1 & Serializable)feature -> {
            Tuple2<String, Short> nameAndLevel = MODULE$.parseNameAndLevel((String)feature);
            return new Tuple2(nameAndLevel._1(), nameAndLevel._2());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ void $anonfun$runFormatCommand$2(Formatter formatter$1, java.util.List x$1) {
        MODULE$.featureNamesAndLevels(x$1).foreachEntry((Function2 & Serializable)(k, v) -> formatter$1.setFeatureLevel(k, v));
    }

    public static final /* synthetic */ void $anonfun$runVersionMappingCommand$2(MetadataVersion metadataVersion$1, PrintStream printStream$1, Feature feature) {
        short featureLevel = feature.defaultLevel(metadataVersion$1);
        printStream$1.print(StringOps$.MODULE$.format$extension("%s=%d%n", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{feature.featureName(), BoxesRunTime.boxToShort((short)featureLevel)})));
    }

    public static final /* synthetic */ boolean $anonfun$runFeatureDependenciesCommand$4(String featureName$1, Feature x$5) {
        String string = x$5.featureName();
        return !(string != null ? !string.equals(featureName$1) : featureName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$runFeatureDependenciesCommand$5(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$runFeatureDependenciesCommand$6(PrintStream printStream$2, Tuple2 x$6) {
        if (x$6 != null) {
            String depFeature = (String)x$6._1();
            Short depLevel = (Short)x$6._2();
            String string = depFeature;
            String string2 = "metadata.version";
            if (string != null && string.equals(string2)) {
                MetadataVersion metadataVersion = MetadataVersion.fromFeatureLevel((short)Predef$.MODULE$.Short2short(depLevel));
                printStream$2.println("    " + depFeature + "=" + depLevel + " (" + metadataVersion.version() + ")");
                return;
            }
            printStream$2.println("    " + depFeature + "=" + depLevel);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$infoCommand$4(PrintStream stream$1, MetaProperties prev) {
        TreeMap sortedOutput = new TreeMap();
        prev.toProperties().entrySet().forEach(e -> sortedOutput.put(e.getKey().toString(), e.getValue().toString()));
        stream$1.println("Found metadata: " + sortedOutput);
        stream$1.println("");
    }

    private StorageTool$() {
    }

    public static final /* synthetic */ Object $anonfun$runFeatureDependenciesCommand$4$adapted(String featureName$1, Feature x$5) {
        return BoxesRunTime.boxToBoolean((boolean)StorageTool$.$anonfun$runFeatureDependenciesCommand$4(featureName$1, x$5));
    }
}

