/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.interpreter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.interpreter.AttributePattern;

public interface Activation {
    public Object resolveName(String var1);

    public Activation parent();

    public static Activation emptyActivation() {
        return Activation.newActivation(new HashMap());
    }

    public static Activation newActivation(Object bindings) {
        if (bindings == null) {
            throw new NullPointerException("bindings must be non-nil");
        }
        if (bindings instanceof Activation) {
            return (Activation)bindings;
        }
        if (bindings instanceof Map) {
            return new MapActivation((Map)bindings);
        }
        throw new IllegalArgumentException(String.format("activation input must be an activation or map[string]interface: got %s", bindings.getClass().getName()));
    }

    public static Activation newHierarchicalActivation(Activation parent, Activation child) {
        return new HierarchicalActivation(parent, child);
    }

    public static PartialActivation newPartialActivation(Object bindings, AttributePattern ... unknowns) {
        Activation a = Activation.newActivation(bindings);
        return new PartActivation(a, unknowns);
    }

    public static final class VarActivation
    implements Activation {
        Activation parent;
        String name;
        Val val;

        VarActivation() {
        }

        @Override
        public Activation parent() {
            return this.parent;
        }

        @Override
        public Object resolveName(String name) {
            if (name.equals(this.name)) {
                return this.val;
            }
            return this.parent.resolveName(name);
        }

        public String toString() {
            return "VarActivation{parent=" + this.parent + ", name='" + this.name + '\'' + ", val=" + this.val + '}';
        }
    }

    public static final class PartActivation
    implements PartialActivation {
        private final Activation delegate;
        private final AttributePattern[] unknowns;

        PartActivation(Activation delegate, AttributePattern[] unknowns) {
            this.delegate = delegate;
            this.unknowns = unknowns;
        }

        @Override
        public Activation parent() {
            return this.delegate.parent();
        }

        @Override
        public Object resolveName(String name) {
            return this.delegate.resolveName(name);
        }

        @Override
        public AttributePattern[] unknownAttributePatterns() {
            return this.unknowns;
        }

        public String toString() {
            return "PartActivation{delegate=" + this.delegate + ", unknowns=" + Arrays.toString(this.unknowns) + '}';
        }
    }

    public static interface PartialActivation
    extends Activation {
        public AttributePattern[] unknownAttributePatterns();
    }

    public static final class HierarchicalActivation
    implements Activation {
        private final Activation parent;
        private final Activation child;

        HierarchicalActivation(Activation parent, Activation child) {
            this.parent = parent;
            this.child = child;
        }

        @Override
        public Activation parent() {
            return this.parent;
        }

        @Override
        public Object resolveName(String name) {
            Object object = this.child.resolveName(name);
            if (object != null) {
                return object;
            }
            return this.parent.resolveName(name);
        }

        public String toString() {
            return "HierarchicalActivation{parent=" + this.parent + ", child=" + this.child + '}';
        }
    }

    public static final class MapActivation
    implements Activation {
        private final Map<String, Object> bindings;

        MapActivation(Map<String, Object> bindings) {
            this.bindings = bindings;
        }

        @Override
        public Activation parent() {
            return null;
        }

        @Override
        public Object resolveName(String name) {
            Object obj = this.bindings.get(name);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Supplier) {
                obj = ((Supplier)obj).get();
                this.bindings.put(name, obj);
            }
            return obj;
        }

        public String toString() {
            return "MapActivation{bindings=" + this.bindings + '}';
        }
    }
}

