/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.confluent.schema.exporter.client.rest.entities.ExporterInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class UpdateExporterRequest {
    private Optional<List<String>> subjects;
    private Optional<ExporterInfo.ContextType> contextType;
    private Optional<String> context;
    private Optional<String> kekRenameFormat;
    private Optional<String> subjectRenameFormat;
    private Optional<Map<String, String>> config;

    public static UpdateExporterRequest fromJson(String json) throws IOException {
        return (UpdateExporterRequest)JacksonMapper.INSTANCE.readValue(json, UpdateExporterRequest.class);
    }

    @JsonProperty(value="subjects")
    public Optional<List<String>> getOptionalSubjects() {
        return this.subjects;
    }

    @JsonIgnore
    public List<String> getSubjects() {
        return this.subjects != null ? (List)this.subjects.orElse(null) : null;
    }

    @JsonProperty(value="subjects")
    public void setSubjects(Optional<List<String>> subjects) {
        this.subjects = subjects;
    }

    @JsonIgnore
    public void setSubjects(List<String> subjects) {
        this.subjects = subjects != null ? Optional.of(subjects) : null;
    }

    @JsonProperty(value="contextType")
    public Optional<ExporterInfo.ContextType> getOptionalContextType() {
        return this.contextType;
    }

    @JsonIgnore
    public ExporterInfo.ContextType getContextType() {
        return this.contextType != null ? (ExporterInfo.ContextType)this.contextType.orElse(null) : null;
    }

    @JsonProperty(value="contextType")
    public void setContextType(Optional<ExporterInfo.ContextType> contextType) {
        this.contextType = contextType;
    }

    @JsonIgnore
    public void setContextType(ExporterInfo.ContextType contextType) {
        this.contextType = contextType != null ? Optional.of(contextType) : null;
    }

    @JsonProperty(value="context")
    public Optional<String> getOptionalContext() {
        return this.context;
    }

    @JsonIgnore
    public String getContext() {
        return this.context != null ? (String)this.context.orElse(null) : null;
    }

    @JsonProperty(value="context")
    public void setContext(Optional<String> context) {
        this.context = context;
    }

    @JsonIgnore
    public void setContext(String context) {
        this.context = context != null ? Optional.of(context) : null;
    }

    @JsonProperty(value="kekRenameFormat")
    public Optional<String> getOptionalKekRenameFormat() {
        return this.kekRenameFormat;
    }

    @JsonIgnore
    public String getKekRenameFormat() {
        return this.kekRenameFormat != null ? (String)this.kekRenameFormat.orElse(null) : null;
    }

    @JsonProperty(value="kekRenameFormat")
    public void setKekRenameFormat(Optional<String> kekRenameFormat) {
        this.kekRenameFormat = kekRenameFormat;
    }

    @JsonIgnore
    public void setKekRenameFormat(String kekRenameFormat) {
        this.kekRenameFormat = kekRenameFormat != null ? Optional.of(kekRenameFormat) : null;
    }

    @JsonProperty(value="subjectRenameFormat")
    public Optional<String> getOptionalSubjectRenameFormat() {
        return this.subjectRenameFormat;
    }

    @JsonIgnore
    public String getSubjectRenameFormat() {
        return this.subjectRenameFormat != null ? (String)this.subjectRenameFormat.orElse(null) : null;
    }

    @JsonProperty(value="subjectRenameFormat")
    public void setSubjectRenameFormat(Optional<String> subjectRenameFormat) {
        this.subjectRenameFormat = subjectRenameFormat;
    }

    @JsonIgnore
    public void setSubjectRenameFormat(String subjectRenameFormat) {
        this.subjectRenameFormat = subjectRenameFormat != null ? Optional.of(subjectRenameFormat) : null;
    }

    @JsonProperty(value="config")
    public Optional<Map<String, String>> getOptionalConfig() {
        return this.config;
    }

    @JsonIgnore
    public Map<String, String> getConfig() {
        return this.config != null ? (Map)this.config.orElse(null) : null;
    }

    @JsonProperty(value="config")
    public void setConfig(Optional<Map<String, String>> config) {
        this.config = config;
    }

    @JsonIgnore
    public void setConfig(Map<String, String> config) {
        this.config = config != null ? Optional.of(config) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateExporterRequest that = (UpdateExporterRequest)o;
        return Objects.equals(this.subjects, that.subjects) && Objects.equals(this.contextType, that.contextType) && Objects.equals(this.context, that.context) && Objects.equals(this.kekRenameFormat, that.kekRenameFormat) && Objects.equals(this.subjectRenameFormat, that.subjectRenameFormat) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.subjects, this.contextType, this.context, this.kekRenameFormat, this.subjectRenameFormat, this.config);
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }
}

