/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.licensing;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.schema.exporter.licensing.entities.SchemaRegistryMetadata;
import io.confluent.schema.exporter.licensing.policies.EnforcementPolicy;
import io.confluent.schema.exporter.licensing.policies.SchemaExporterPolicyFactory;
import io.confluent.schema.exporter.licensing.utils.MetadataUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseEnforcementService {
    private static final Logger log = LoggerFactory.getLogger(LicenseEnforcementService.class);
    private final SchemaRegistryClient client;

    public LicenseEnforcementService(SchemaRegistryClient client) {
        this.client = client;
    }

    public void enforceLicenseCompatibility(SchemaRegistryClient destinationClient) throws SchemaRegistryException {
        log.debug("Starting license enforcement for exporter operation");
        if (destinationClient == null) {
            throw new IllegalArgumentException("Destination client cannot be null");
        }
        try {
            SchemaRegistryMetadata localMetadata = MetadataUtils.getMetadata(this.client);
            SchemaRegistryMetadata destMetadata = MetadataUtils.getMetadata(destinationClient);
            log.debug("Local metadata: {}", (Object)localMetadata);
            log.debug("Destination metadata: {}", (Object)destMetadata);
            List<EnforcementPolicy> policies = SchemaExporterPolicyFactory.createPolicies(localMetadata.getVersion());
            log.debug("Using {} enforcement policies for local version {}", (Object)policies.size(), (Object)localMetadata.getVersion());
            for (EnforcementPolicy policy : policies) {
                log.debug("Applying policy: {} for local version {}", (Object)policy.getPolicyName(), (Object)localMetadata.getVersion());
                policy.enforce(localMetadata, destMetadata);
            }
            log.debug("License enforcement completed successfully");
        }
        catch (Exception e) {
            log.error("License enforcement failed: {}", (Object)e.getMessage(), (Object)e);
            if (e instanceof SchemaRegistryException) {
                throw (SchemaRegistryException)((Object)e);
            }
            throw e;
        }
    }
}

