/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.licensing;

import io.confluent.schema.exporter.licensing.entities.DeploymentScope;
import io.confluent.schema.exporter.licensing.entities.LicensePrivilegeLevel;
import io.confluent.schema.exporter.licensing.entities.LicenseType;
import io.confluent.schema.exporter.licensing.entities.V1License;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicensePrivilegeManager {
    private static final Logger log = LoggerFactory.getLogger(LicensePrivilegeManager.class);

    public static LicensePrivilegeLevel determineHighestPrivilegeLevel(List<V1License> licenses) {
        if (licenses == null || licenses.isEmpty()) {
            return LicensePrivilegeLevel.NONE;
        }
        LicensePrivilegeLevel highestPrivilege = LicensePrivilegeLevel.UNKNOWN;
        for (V1License license : licenses) {
            if (license == null) continue;
            LicensePrivilegeLevel currentPrivilege = LicensePrivilegeManager.getLicensePrivilegeLevel(license);
            if (currentPrivilege.isHigherThan(highestPrivilege)) {
                highestPrivilege = currentPrivilege;
            }
            if (highestPrivilege != LicensePrivilegeLevel.CONFLUENT_CLOUD) continue;
            break;
        }
        return highestPrivilege;
    }

    public static LicensePrivilegeLevel getLicensePrivilegeLevel(V1License license) {
        LicenseType licenseType = license.getLicenseType();
        DeploymentScope deploymentScope = license.getDeploymentScope();
        if (licenseType == LicenseType.CONFLUENT_CLOUD || deploymentScope == DeploymentScope.CONFLUENT_CLOUD) {
            return LicensePrivilegeLevel.CONFLUENT_CLOUD;
        }
        if ((licenseType == LicenseType.ENTERPRISE || licenseType == LicenseType.CSFLE) && deploymentScope != DeploymentScope.CP_FOR_CC) {
            return LicensePrivilegeLevel.ENTERPRISE;
        }
        if (deploymentScope == DeploymentScope.CP_FOR_CC) {
            return LicensePrivilegeLevel.CP_FOR_CC;
        }
        if (licenseType == LicenseType.UNKNOWN || deploymentScope == DeploymentScope.UNKNOWN) {
            return LicensePrivilegeLevel.UNKNOWN;
        }
        return LicensePrivilegeLevel.COMMUNITY;
    }
}

