/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.licensing.entities;

import io.confluent.schema.exporter.licensing.entities.V1License;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseDeserializer {
    private static final Logger log = LoggerFactory.getLogger(LicenseDeserializer.class);

    public static List<V1License> deserializeDeploymentAttributes(Set<String> attributes) {
        ArrayList<V1License> v1Licenses = new ArrayList<V1License>();
        if (attributes == null || attributes.isEmpty()) {
            return v1Licenses;
        }
        for (String attribute : attributes) {
            try {
                if (!LicenseDeserializer.isV1LicenseAttribute(attribute)) continue;
                V1License license = V1License.fromAttributeString(attribute);
                v1Licenses.add(license);
                log.debug("Parsed V1License: {}", (Object)license);
            }
            catch (Exception e) {
                log.warn("Could not parse V1License from attribute: {}", (Object)attribute, (Object)e);
            }
        }
        log.debug("Parsed {} V1License entities from {} attributes", (Object)v1Licenses.size(), (Object)attributes.size());
        return v1Licenses;
    }

    public static boolean isV1LicenseAttribute(String attribute) {
        return attribute != null && attribute.startsWith("license_v1_");
    }
}

