/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.licensing.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.schema.exporter.licensing.entities.DeploymentScope;
import io.confluent.schema.exporter.licensing.entities.LicenseType;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class V1License {
    private static final String TYPE = "license";
    private static final String VERSION = "v1";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String key;
    private final LicenseType licenseType;
    private final DeploymentScope deploymentScope;

    @JsonCreator
    public V1License(@JsonProperty(value="licenseType") LicenseType licenseType, @JsonProperty(value="deploymentScope") DeploymentScope deploymentScope) {
        this.licenseType = licenseType;
        this.deploymentScope = deploymentScope;
        this.key = V1License.generateKey(licenseType, deploymentScope);
    }

    private static String generateKey(LicenseType licenseType, DeploymentScope deploymentScope) {
        if (licenseType == null || deploymentScope == null) {
            throw new IllegalArgumentException("License type and deployment scope cannot be null");
        }
        String composite = licenseType.toString() + ":" + deploymentScope.toString();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(composite.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return "license_v1_" + hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }

    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="licenseType")
    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    @JsonProperty(value="deploymentScope")
    public DeploymentScope getDeploymentScope() {
        return this.deploymentScope;
    }

    public String toJson() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize V1License to JSON", e);
        }
    }

    public static V1License fromJson(String json) {
        try {
            return (V1License)OBJECT_MAPPER.readValue(json, V1License.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize V1License from JSON", e);
        }
    }

    public String toAttributeString() {
        return this.getKey() + ":" + this.toJson();
    }

    public static V1License fromAttributeString(String attributeString) {
        if (attributeString == null || !attributeString.contains(":")) {
            throw new IllegalArgumentException("Invalid attribute string format");
        }
        int colonIndex = attributeString.indexOf(":");
        String key = attributeString.substring(0, colonIndex);
        String json = attributeString.substring(colonIndex + 1);
        if (!key.startsWith("license_v1_")) {
            throw new IllegalArgumentException("Not a V1License attribute string");
        }
        V1License license = V1License.fromJson(json);
        if (!key.equals(license.getKey())) {
            throw new IllegalArgumentException("Key mismatch in attribute string");
        }
        return license;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        V1License that = (V1License)obj;
        return Objects.equals(this.key, that.key) && this.licenseType == that.licenseType && this.deploymentScope == that.deploymentScope;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.licenseType, this.deploymentScope});
    }

    public String toString() {
        return "V1License{key='" + this.key + "', licenseType=" + String.valueOf((Object)this.licenseType) + ", deploymentScope=" + String.valueOf((Object)this.deploymentScope) + "}";
    }
}

