/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.licensing.policies;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.schema.exporter.licensing.LicensePrivilegeManager;
import io.confluent.schema.exporter.licensing.entities.LicensePrivilegeLevel;
import io.confluent.schema.exporter.licensing.entities.SchemaRegistryMetadata;
import io.confluent.schema.exporter.licensing.entities.V1License;
import io.confluent.schema.exporter.licensing.policies.EnforcementPolicy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingEnforcementPolicy
implements EnforcementPolicy {
    private Logger log = LoggerFactory.getLogger(LoggingEnforcementPolicy.class);

    @Override
    public void enforce(SchemaRegistryMetadata localMetadata, SchemaRegistryMetadata destMetadata) {
        List<V1License> localLicenses = localMetadata.getLicenses();
        List<V1License> destLicenses = destMetadata.getLicenses();
        LicensePrivilegeLevel localPrivilegeLevel = LicensePrivilegeManager.determineHighestPrivilegeLevel(localLicenses);
        LicensePrivilegeLevel destPrivilegeLevel = LicensePrivilegeManager.determineHighestPrivilegeLevel(destLicenses);
        if (localPrivilegeLevel == LicensePrivilegeLevel.CP_FOR_CC && destPrivilegeLevel != LicensePrivilegeLevel.CP_FOR_CC && destPrivilegeLevel != LicensePrivilegeLevel.CONFLUENT_CLOUD) {
            this.log.warn("WARNING: Your license for Customer-Managed Confluent Platform for Confluent Cloud may be used solely to access and use the Cloud Service. When operating under this specific license, Confluent does not provide support for any self-managed (Confluent Platform) components utilised exclusively for Confluent Platform broker use cases. To be eligible for support, you must ensure you are connecting to a Confluent Cloud broker or are utilising a valid Enterprise license for a Confluent Platform subscription.");
        }
    }

    @Override
    public String getPolicyName() {
        return "LoggingEnforcementPolicy";
    }

    @VisibleForTesting
    public void setLogger(Logger logger) {
        this.log = logger;
    }
}

