/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.licensing.policies;

import io.confluent.schema.exporter.licensing.policies.EnforcementPolicy;
import io.confluent.schema.exporter.licensing.policies.LoggingEnforcementPolicy;
import io.confluent.schema.exporter.licensing.policies.StrictEnforcementPolicy;
import io.confluent.schema.exporter.licensing.utils.VersionUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterPolicyFactory {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterPolicyFactory.class);

    public static List<EnforcementPolicy> createPolicies(String localVersion) {
        ArrayList<EnforcementPolicy> policies = new ArrayList<EnforcementPolicy>();
        if (localVersion == null || localVersion.equals("unknown")) {
            log.warn("Unable to determine local version for license enforcement.");
            return policies;
        }
        if (VersionUtils.isVersionGreaterThan(localVersion, "8.1.0") || VersionUtils.isVersion8_1(localVersion)) {
            policies.add(new StrictEnforcementPolicy());
        } else if (VersionUtils.isVersion8_0(localVersion)) {
            policies.add(new LoggingEnforcementPolicy());
        }
        return policies;
    }
}

