/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.licensing.policies;

import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.schema.exporter.licensing.LicensePrivilegeManager;
import io.confluent.schema.exporter.licensing.entities.LicensePrivilegeLevel;
import io.confluent.schema.exporter.licensing.entities.SchemaRegistryMetadata;
import io.confluent.schema.exporter.licensing.entities.V1License;
import io.confluent.schema.exporter.licensing.policies.EnforcementPolicy;
import io.confluent.schema.exporter.licensing.utils.VersionUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrictEnforcementPolicy
implements EnforcementPolicy {
    private Logger log = LoggerFactory.getLogger(StrictEnforcementPolicy.class);

    @Override
    public void enforce(SchemaRegistryMetadata localMetadata, SchemaRegistryMetadata destMetadata) throws SchemaRegistryException {
        List<V1License> localLicense = localMetadata.getLicenses();
        List<V1License> destLicense = destMetadata.getLicenses();
        LicensePrivilegeLevel localPrivilege = LicensePrivilegeManager.determineHighestPrivilegeLevel(localLicense);
        LicensePrivilegeLevel destPrivilege = LicensePrivilegeManager.determineHighestPrivilegeLevel(destLicense);
        if (localPrivilege == LicensePrivilegeLevel.CONFLUENT_CLOUD || destPrivilege == LicensePrivilegeLevel.CONFLUENT_CLOUD) {
            return;
        }
        if (localPrivilege != LicensePrivilegeLevel.CP_FOR_CC) {
            return;
        }
        if (destPrivilege == LicensePrivilegeLevel.UNKNOWN || VersionUtils.isVersionLessThan(destMetadata.getVersion(), "8.0.0") || destMetadata.getVersion().equals("unknown")) {
            this.log.warn("WARNING: Your license for Customer-Managed Confluent Platform for Confluent Cloud may be used solely to access and use the Cloud Service. When operating under this specific license, Confluent does not provide support for any self-managed (Confluent Platform) components utilised exclusively for Confluent Platform broker use cases. To be eligible for support, you must ensure you are connecting to a Confluent Cloud broker or are utilising a valid Enterprise license for a Confluent Platform subscription.");
            return;
        }
        this.log.debug("Applying CP 8.1.x strict enforcement policy: local={}, dest={}", localLicense, destLicense);
        if (this.isRejectionScenario(localPrivilege, destPrivilege)) {
            return;
        }
        if (this.isInfoScenario(localPrivilege, destPrivilege)) {
            return;
        }
        if (this.isWarningScenario(localPrivilege, destPrivilege)) {
            return;
        }
        this.log.debug("No strict enforcement applied for local license {} and dest license {}", localLicense, destLicense);
    }

    public boolean isRejectionScenario(LicensePrivilegeLevel localPrivilege, LicensePrivilegeLevel destPrivilege) throws SchemaRegistryException {
        if (destPrivilege == LicensePrivilegeLevel.UNKNOWN) {
            return false;
        }
        if (destPrivilege != LicensePrivilegeLevel.CP_FOR_CC && destPrivilege != LicensePrivilegeLevel.CONFLUENT_CLOUD) {
            this.log.error("WARNING: Your license for Customer-Managed Confluent Platform for Confluent Cloud may be used solely to access and use the Cloud Service. When operating under this specific license, Confluent does not provide support for any self-managed (Confluent Platform) components utilised exclusively for Confluent Platform broker use cases. To be eligible for support, you must ensure you are connecting to a Confluent Cloud broker or are utilising a valid Enterprise license for a Confluent Platform subscription.");
            throw new SchemaRegistryException("WARNING: Your license for Customer-Managed Confluent Platform for Confluent Cloud may be used solely to access and use the Cloud Service. When operating under this specific license, Confluent does not provide support for any self-managed (Confluent Platform) components utilised exclusively for Confluent Platform broker use cases. To be eligible for support, you must ensure you are connecting to a Confluent Cloud broker or are utilising a valid Enterprise license for a Confluent Platform subscription.");
        }
        return false;
    }

    public boolean isWarningScenario(LicensePrivilegeLevel localPrivilege, LicensePrivilegeLevel destPrivilege) {
        if (destPrivilege != LicensePrivilegeLevel.CONFLUENT_CLOUD) {
            this.log.warn("WARNING: Your license for Customer-Managed Confluent Platform for Confluent Cloud may be used solely to access and use the Cloud Service. When operating under this specific license, Confluent does not provide support for any self-managed (Confluent Platform) components utilised exclusively for Confluent Platform broker use cases. To be eligible for support, you must ensure you are connecting to a Confluent Cloud broker or are utilising a valid Enterprise license for a Confluent Platform subscription.");
            return true;
        }
        return false;
    }

    public boolean isInfoScenario(LicensePrivilegeLevel localPrivilege, LicensePrivilegeLevel destPrivilege) {
        if (localPrivilege == LicensePrivilegeLevel.CP_FOR_CC && destPrivilege == LicensePrivilegeLevel.CP_FOR_CC) {
            this.log.info("Confluent Platform for Confluent Cloud licenses should be used to connect to Confluent Cloud.");
            return true;
        }
        return false;
    }

    @Override
    public String getPolicyName() {
        return "StrictEnforcementPolicy8_1_x";
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }
}

