/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.licensing.utils;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryDeployment;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryServerVersion;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.schema.exporter.licensing.entities.DeploymentScope;
import io.confluent.schema.exporter.licensing.entities.LicenseDeserializer;
import io.confluent.schema.exporter.licensing.entities.LicenseType;
import io.confluent.schema.exporter.licensing.entities.SchemaRegistryMetadata;
import io.confluent.schema.exporter.licensing.entities.V1License;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataUtils {
    private static final Logger log = LoggerFactory.getLogger(MetadataUtils.class);

    public static SchemaRegistryMetadata getMetadata(SchemaRegistryClient client) throws SchemaRegistryException {
        List<V1License> licenses = MetadataUtils.getLicenses(client);
        String version = MetadataUtils.getVersion(client);
        if (version == null) {
            log.warn("Version could not be determined, using 'unknown'");
            version = "unknown";
        }
        return new SchemaRegistryMetadata(licenses, version);
    }

    public static List<V1License> getLicenses(SchemaRegistryClient client) throws SchemaRegistryException {
        try {
            SchemaRegistryDeployment deployment = client.getSchemaRegistryDeployment();
            List<V1License> desLicenses = LicenseDeserializer.deserializeDeploymentAttributes(new HashSet<String>(deployment.getAttributes()));
            if (desLicenses.isEmpty()) {
                V1License openSourceLicense = new V1License(LicenseType.OPEN_SOURCE, DeploymentScope.CP);
                desLicenses.add(openSourceLicense);
            }
            return desLicenses;
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("404")) {
                log.info("Deployment endpoint not found in destination SR");
            }
            log.info("Failed to query endpoints, treating as unknown: {}", (Object)e.getMessage());
            ArrayList<V1License> list = new ArrayList<V1License>();
            list.add(new V1License(LicenseType.UNKNOWN, DeploymentScope.UNKNOWN));
            return list;
        }
    }

    public static String getVersion(SchemaRegistryClient client) {
        try {
            SchemaRegistryServerVersion versionInfo = client.getSchemaRegistryServerVersion();
            return versionInfo.getVersion();
        }
        catch (Exception e) {
            log.warn("Failed to query version endpoint: {}", (Object)e.getMessage());
            return null;
        }
    }
}

