/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.licensing.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionUtils {
    public static final String UNKNOWN_VERSION = "unknown";

    public static boolean isVersion8_1(String version) {
        return version != null && version.startsWith("8.1");
    }

    public static boolean isVersion8_0(String version) {
        if (version == null) {
            return false;
        }
        return version.startsWith("8.0");
    }

    public static boolean isVersionLessThan(String version, String targetVersion) {
        if (version == null || targetVersion == null) {
            return false;
        }
        String cleanVersion = VersionUtils.cleanVersion(version);
        String cleanTargetVersion = VersionUtils.cleanVersion(targetVersion);
        String[] versionParts = cleanVersion.split("\\.");
        String[] targetParts = cleanTargetVersion.split("\\.");
        int maxLength = Math.max(versionParts.length, targetParts.length);
        for (int i = 0; i < maxLength; ++i) {
            int targetPart;
            int versionPart = i < versionParts.length ? VersionUtils.parseLeadingInt(versionParts[i]) : 0;
            int n = targetPart = i < targetParts.length ? VersionUtils.parseLeadingInt(targetParts[i]) : 0;
            if (versionPart == targetPart) continue;
            return versionPart < targetPart;
        }
        return false;
    }

    public static boolean isVersionGreaterThan(String version, String targetVersion) {
        if (version == null || targetVersion == null) {
            return false;
        }
        String cleanVersion = VersionUtils.cleanVersion(version);
        String cleanTargetVersion = VersionUtils.cleanVersion(targetVersion);
        String[] versionParts = cleanVersion.split("\\.");
        String[] targetParts = cleanTargetVersion.split("\\.");
        int maxLength = Math.max(versionParts.length, targetParts.length);
        for (int i = 0; i < maxLength; ++i) {
            int targetPart;
            int versionPart = i < versionParts.length ? VersionUtils.parseLeadingInt(versionParts[i]) : 0;
            int n = targetPart = i < targetParts.length ? VersionUtils.parseLeadingInt(targetParts[i]) : 0;
            if (versionPart == targetPart) continue;
            return versionPart > targetPart;
        }
        return false;
    }

    public static String cleanVersion(String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("^\\d+(?:\\.\\d+)*").matcher(version);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    private static int parseLeadingInt(String str) {
        if (str == null || str.trim().isEmpty()) {
            return 0;
        }
        try {
            Matcher matcher = Pattern.compile("^\\d+").matcher(str.trim());
            if (matcher.find()) {
                return Integer.parseInt(matcher.group());
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

