/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.metrics;

import io.confluent.schema.exporter.metrics.ExporterGauge;
import io.confluent.schema.exporter.metrics.KafkaMetricsGauge;
import io.confluent.schema.exporter.metrics.MetricDescriptor;
import io.confluent.schema.exporter.metrics.MetricTags;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExporterStatusGauges {
    public final ConcurrentHashMap<SchemaExporter, SchemaExporterStatus> exporterStatusMap = new ConcurrentHashMap();
    public final Map<MetricName, ExporterGauge> perExporterGaugeMap = new ConcurrentHashMap<MetricName, ExporterGauge>();
    private final Metrics metrics;
    private static final Logger log = LoggerFactory.getLogger(ExporterStatusGauges.class);

    public ExporterStatusGauges(Metrics metrics) {
        this.metrics = metrics;
    }

    public void reset() {
        this.perExporterGaugeMap.values().forEach(ExporterGauge::reset);
    }

    public void addExporterStatus(SchemaExporter exporter, SchemaExporterStatus newStatus) {
        if (exporter == null) {
            return;
        }
        this.exporterStatusMap.compute(exporter, (key, oldStatus) -> {
            if (newStatus == null) {
                if (oldStatus != null) {
                    this.removeExporterStatus(exporter, (SchemaExporterStatus)oldStatus);
                }
                return null;
            }
            if (oldStatus == null) {
                this.addExporterStatusInternal(exporter, newStatus);
                return newStatus;
            }
            if (oldStatus.getState() == newStatus.getState()) {
                return newStatus;
            }
            this.removeExporterStatus(exporter, (SchemaExporterStatus)oldStatus);
            this.addExporterStatusInternal(exporter, newStatus);
            return newStatus;
        });
    }

    private void addExporterStatusInternal(SchemaExporter exporter, SchemaExporterStatus status) {
        if (status == null) {
            return;
        }
        SchemaExporterStatus.State state = status.getState();
        boolean hasError = status.getTrace() != null && !status.getTrace().isEmpty();
        boolean isRetriable = status.isRetriable();
        String exporterName = exporter.getName();
        String tenant = exporter.getTenant();
        ExporterGauge perExporterGauge = this.getOrCreatePerExporterGauge(tenant, exporterName, state, hasError, isRetriable);
        perExporterGauge.set(1L);
    }

    public void removeExporterStatus(SchemaExporter exporter, SchemaExporterStatus status) {
        if (exporter == null) {
            return;
        }
        if (status == null) {
            return;
        }
        SchemaExporterStatus.State state = status.getState();
        boolean hasError = status.getTrace() != null && !status.getTrace().isEmpty();
        boolean isRetriable = status.isRetriable();
        String exporterName = exporter.getName();
        String tenant = exporter.getTenant();
        MetricName metricName = MetricTags.buildMetricName(MetricDescriptor.EXPORTER_TASKS_GAUGE, MetricTags.tagsForExporterGauge(tenant, exporterName, state.name(), hasError, isRetriable));
        ExporterGauge perExporterGauge = this.perExporterGaugeMap.get(metricName);
        if (perExporterGauge != null) {
            perExporterGauge.set(0L);
            this.metrics.removeMetric(metricName);
            this.perExporterGaugeMap.remove(metricName);
        } else {
            this.metrics.removeMetric(metricName);
        }
        this.exporterStatusMap.remove(exporter);
    }

    public void removeAllExporterGauges(SchemaExporter exporter) {
        this.perExporterGaugeMap.entrySet().removeIf(entry -> {
            boolean shouldRemove;
            boolean tenantMatches;
            String tenantTag = (String)((MetricName)entry.getKey()).tags().get("tenant");
            String exporterNameTag = (String)((MetricName)entry.getKey()).tags().get("exporter_name");
            boolean bl = tenantTag == null ? exporter.getTenant() == null : (tenantMatches = tenantTag.equals(exporter.getTenant()));
            boolean nameMatches = exporterNameTag == null ? exporter.getName() == null : exporterNameTag.equals(exporter.getName());
            boolean bl2 = shouldRemove = tenantMatches && nameMatches;
            if (shouldRemove) {
                ExporterGauge gauge = (ExporterGauge)entry.getValue();
                if (gauge != null) {
                    gauge.set(0L);
                }
                this.metrics.removeMetric((MetricName)entry.getKey());
            }
            return shouldRemove;
        });
    }

    private ExporterGauge getOrCreatePerExporterGauge(String tenant, String exporterName, SchemaExporterStatus.State state, boolean hasError, boolean isRetriable) {
        MetricName metricName = MetricTags.buildMetricName(MetricDescriptor.EXPORTER_TASKS_GAUGE, MetricTags.tagsForExporterGauge(tenant, exporterName, state.name(), hasError, isRetriable));
        return this.perExporterGaugeMap.computeIfAbsent(metricName, k -> new KafkaMetricsGauge(this.metrics, (MetricName)k));
    }

    public Map<SchemaExporter, SchemaExporterStatus> getExporterStatusMap() {
        return this.exporterStatusMap;
    }

    public long getExporterCount() {
        return this.perExporterGaugeMap.size();
    }
}

