/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.metrics;

import io.confluent.schema.exporter.metrics.ExporterGauge;
import io.confluent.schema.exporter.metrics.MetricDescriptor;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;

public class KafkaMetricsGauge
implements Gauge<Long>,
ExporterGauge {
    private final AtomicLong value = new AtomicLong(0L);

    public KafkaMetricsGauge(Metrics metrics, MetricDescriptor md) {
        if (metrics.metric(md.toMetricName(null)) != null) {
            metrics.removeMetric(md.toMetricName(null));
        }
        metrics.addMetric(md.toMetricName(null), (MetricValueProvider)this);
    }

    public KafkaMetricsGauge(Metrics metrics, MetricDescriptor md, String tenant) {
        if (metrics.metric(md.toMetricName(tenant)) != null) {
            metrics.removeMetric(md.toMetricName(tenant));
        }
        metrics.addMetric(md.toMetricName(tenant), (MetricValueProvider)this);
    }

    public KafkaMetricsGauge(Metrics metrics, MetricDescriptor md, String tenant, Map<String, String> tags) {
        if (metrics.metric(md.toMetricName(tenant, tags)) != null) {
            metrics.removeMetric(md.toMetricName(tenant, tags));
        }
        metrics.addMetric(md.toMetricName(tenant, tags), (MetricValueProvider)this);
    }

    public KafkaMetricsGauge(Metrics metrics, MetricName metricName) {
        if (metrics.metric(metricName) != null) {
            metrics.removeMetric(metricName);
        }
        metrics.addMetric(metricName, (MetricValueProvider)this);
    }

    @Override
    public void reset() {
        this.value.set(0L);
    }

    @Override
    public long set(long value) {
        this.value.set(value);
        return this.value.get();
    }

    @Override
    public long increment(long delta) {
        return this.value.addAndGet(1L);
    }

    @Override
    public long decrement(long delta) {
        return this.value.addAndGet(-delta);
    }

    @Override
    public long getValue() {
        return this.value.get();
    }

    public Long value(MetricConfig config, long now) {
        return this.value.get();
    }
}

