/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.metrics;

import io.confluent.schema.exporter.metrics.Counter;
import io.confluent.schema.exporter.metrics.ExporterGauge;
import io.confluent.schema.exporter.metrics.MetricTags;
import io.confluent.schema.exporter.metrics.MetricUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.MetricName;

public enum MetricDescriptor {
    ERRORED_EXPORTERS_COUNT("exporters_errored_total", "exporter", "Count of exporters that errored while running", Counter.class),
    EXPORTER_TASKS_GAUGE("exporter_tasks", "exporter", "Exporter tasks by state", ExporterGauge.class),
    EXPORTER_START_ERROR_COUNT("exporter_service_start_failure_total", "exporter", "Count of schema exporter service failures", Counter.class),
    SCHEMA_TRANSFER_SUCCESS_TOTAL("schema_transfer_success_total", "exporter", "Total count of successfully transferred schemas", Counter.class),
    EXPORTER_STARTING_PROGRESS("exporter_starting_progress", "exporter", "Progress of exporter starting task", ExporterGauge.class),
    EXPORTER_OBJECTS_SYNC_TOTAL("exporter_objects_sync_total", "exporter", "Total count of successful sync operations by object type and operation", Counter.class),
    EXPORTER_LIFECYCLE_LATENCY("exporter_lifecycle_latency", "exporter", "Exporter lifecycle latency in ms", ExporterGauge.class);

    public final String metricName;
    public final String group;
    public final String description;
    public final Class<?> type;

    private MetricDescriptor(String metricName, String group, String description, Class<?> type) {
        this.metricName = metricName;
        this.group = group;
        this.description = description;
        this.type = type;
    }

    public MetricName toMetricName(String tenant) {
        if (tenant == null) {
            return new MetricName(this.metricName, this.group, this.description, new HashMap());
        }
        return new MetricName(this.metricName, this.group, this.description, MetricUtils.tenantTagMap(MetricTags.TENANT_TAG.tagName, tenant));
    }

    public MetricName toMetricName(String tenant, Map<String, String> tags) {
        if (tenant == null) {
            return new MetricName(this.metricName, this.group, this.description, tags);
        }
        HashMap<String, String> mergedTags = new HashMap<String, String>(tags);
        mergedTags.putAll(MetricUtils.tenantTagMap(MetricTags.TENANT_TAG.tagName, tenant));
        return new MetricName(this.metricName, this.group, this.description, mergedTags);
    }
}

