/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.metrics;

import io.confluent.schema.exporter.metrics.MetricDescriptor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.MetricName;

public enum MetricTags {
    TENANT_TAG("tenant"),
    NAME("exporter_name"),
    HAS_ERROR("has_error"),
    IS_RETRIABLE("is_retriable"),
    EXPORTER_STATE("exporter_state"),
    ERROR_TYPE("error_type"),
    OPERATION("operation");

    public final String tagName;

    private MetricTags(String tagName) {
        this.tagName = tagName;
    }

    public String toString() {
        return this.tagName;
    }

    public static Map<String, String> tagsWithTenant(String tenant) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(MetricTags.TENANT_TAG.tagName, tenant);
        return tags;
    }

    public static Map<String, String> tagsWithTenantAndName(String tenant, String name) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put(MetricTags.TENANT_TAG.tagName, tenant);
        tags.put(MetricTags.NAME.tagName, name);
        return tags;
    }

    public static MetricName buildMetricName(MetricDescriptor descriptor, Map<String, String> tags) {
        return new MetricName(descriptor.metricName, descriptor.group, descriptor.description, tags);
    }

    public static MetricName buildMetricNameWithTenant(MetricDescriptor descriptor, String tenant, String name) {
        return MetricTags.buildMetricName(descriptor, MetricTags.tagsWithTenantAndName(tenant, name));
    }

    public static MetricName buildErrorMetricName(String tenant, String exporterName, String operation, String errorType) {
        Map<String, String> tags = MetricTags.tagsWithTenantAndName(tenant, exporterName);
        tags.put(MetricTags.ERROR_TYPE.tagName, errorType);
        tags.put(MetricTags.OPERATION.tagName, operation);
        return MetricTags.buildMetricName(MetricDescriptor.ERRORED_EXPORTERS_COUNT, tags);
    }

    public static Map<String, String> tagsForExporterGauge(String tenant, String exporterName, String state, boolean hasError, boolean isRetriable) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put(MetricTags.TENANT_TAG.tagName, tenant);
        tags.put(MetricTags.NAME.tagName, exporterName);
        tags.put(MetricTags.EXPORTER_STATE.tagName, state);
        tags.put(MetricTags.HAS_ERROR.tagName, String.valueOf(hasError));
        tags.put(MetricTags.IS_RETRIABLE.tagName, String.valueOf(isRetriable));
        return tags;
    }

    public static MetricName buildOperationMetricName(String tenant, String exporterName, String objectType, String operation) {
        Map<String, String> tags = MetricTags.tagsWithTenantAndName(tenant, exporterName);
        tags.put("object_type", objectType);
        tags.put(MetricTags.OPERATION.tagName, operation);
        return MetricTags.buildMetricName(MetricDescriptor.EXPORTER_OBJECTS_SYNC_TOTAL, tags);
    }
}

