/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.metrics;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.schema.exporter.metrics.Counter;
import io.confluent.schema.exporter.metrics.MetricDescriptor;
import io.confluent.schema.exporter.metrics.TenantMetrics;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.metrics.Metrics;

@Singleton
public class MetricsManager
implements Closeable {
    public static final String KEY = "metricsManager";
    static final String METRIC_GROUP = "exporter";
    private final Map<String, TenantMetrics> tenantToMetrics = new ConcurrentHashMap<String, TenantMetrics>();
    public final Counter exporterServiceStartFailures;
    private final Metrics metrics;

    @Inject
    public MetricsManager(SchemaRegistry schemaRegistry) {
        this.metrics = ((KafkaSchemaRegistry)schemaRegistry).getMetricsContainer().getMetrics();
        schemaRegistry.properties().put(KEY, this);
        this.exporterServiceStartFailures = new Counter(this.metrics, MetricDescriptor.EXPORTER_START_ERROR_COUNT);
    }

    public TenantMetrics getTenantMetrics(String tenant) {
        return this.tenantToMetrics.computeIfAbsent(tenant, k -> new TenantMetrics(this.metrics, tenant));
    }

    public long getExporterCount(String tenant) {
        return this.getTenantMetrics((String)tenant).exporterStatusGauges.getExporterCount();
    }

    @Override
    public void close() {
        this.metrics.close();
    }
}

