/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.metrics;

import io.confluent.schema.exporter.metrics.Counter;
import io.confluent.schema.exporter.metrics.ExporterGauge;
import io.confluent.schema.exporter.metrics.ExporterStatusGauges;
import io.confluent.schema.exporter.metrics.KafkaMetricsGauge;
import io.confluent.schema.exporter.metrics.MetricDescriptor;
import io.confluent.schema.exporter.metrics.MetricTags;
import io.confluent.schema.exporter.storage.SchemaExporter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantMetrics {
    private static final Logger log = LoggerFactory.getLogger(TenantMetrics.class);
    public final Metrics metrics;
    public final String tenant;
    public final Counter exporterErroredTotal;
    public final ExporterStatusGauges exporterStatusGauges;
    public final ExporterGauge exporterLifecycleLatencyGauge;
    public final Map<MetricName, ExporterGauge> metricNameToGaugeMap = new ConcurrentHashMap<MetricName, ExporterGauge>();
    public final Map<MetricName, Counter> metricNameToCounterMap = new ConcurrentHashMap<MetricName, Counter>();

    public TenantMetrics(Metrics metrics, String tenant) {
        this.metrics = metrics;
        this.tenant = tenant;
        this.exporterErroredTotal = new Counter(metrics, MetricDescriptor.ERRORED_EXPORTERS_COUNT, tenant);
        this.exporterStatusGauges = new ExporterStatusGauges(metrics);
        this.exporterLifecycleLatencyGauge = new KafkaMetricsGauge(metrics, MetricDescriptor.EXPORTER_LIFECYCLE_LATENCY, tenant);
    }

    public Counter getCounter(MetricName metricName) {
        if (metricName == null) {
            throw new IllegalArgumentException("MetricName cannot be null");
        }
        return this.metricNameToCounterMap.computeIfAbsent(metricName, k -> new Counter(this.metrics, metricName));
    }

    public ExporterGauge getGauge(MetricName metricName) {
        if (metricName == null) {
            throw new IllegalArgumentException("MetricName cannot be null");
        }
        return this.metricNameToGaugeMap.computeIfAbsent(metricName, k -> new KafkaMetricsGauge(this.metrics, (MetricName)k));
    }

    public ExporterGauge getOrCreateLifecycleLatencyGauge(String exporterName, String state) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put(MetricTags.TENANT_TAG.tagName, this.tenant);
        tags.put(MetricTags.NAME.tagName, exporterName);
        tags.put(MetricTags.EXPORTER_STATE.tagName, state);
        MetricName metricName = MetricTags.buildMetricName(MetricDescriptor.EXPORTER_LIFECYCLE_LATENCY, tags);
        return this.getGauge(metricName);
    }

    public void deleteExporter(SchemaExporter exporter) {
        this.exporterStatusGauges.addExporterStatus(exporter, null);
        this.exporterStatusGauges.removeAllExporterGauges(exporter);
        this.metricNameToCounterMap.entrySet().removeIf(entry -> {
            boolean shouldRemove;
            boolean bl = shouldRemove = ((String)((MetricName)entry.getKey()).tags().get(MetricTags.NAME.tagName)).equals(exporter.getName()) && ((String)((MetricName)entry.getKey()).tags().get(MetricTags.TENANT_TAG.tagName)).equals(exporter.getTenant());
            if (shouldRemove) {
                this.metrics.removeMetric((MetricName)entry.getKey());
            }
            return shouldRemove;
        });
        this.metricNameToGaugeMap.entrySet().removeIf(entry -> {
            boolean shouldRemove;
            boolean bl = shouldRemove = ((String)((MetricName)entry.getKey()).tags().get(MetricTags.NAME.tagName)).equals(exporter.getName()) && ((String)((MetricName)entry.getKey()).tags().get(MetricTags.TENANT_TAG.tagName)).equals(exporter.getTenant());
            if (shouldRemove) {
                this.metrics.removeMetric((MetricName)entry.getKey());
            }
            return shouldRemove;
        });
    }
}

