/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import io.confluent.dekregistry.client.CachedDekRegistryClient;
import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.client.rest.entities.Kek;
import io.confluent.dekregistry.storage.DataEncryptionKey;
import io.confluent.dekregistry.storage.DataEncryptionKeyId;
import io.confluent.dekregistry.storage.DekRegistry;
import io.confluent.dekregistry.storage.EncryptionKey;
import io.confluent.dekregistry.storage.EncryptionKeyId;
import io.confluent.dekregistry.storage.KeyEncryptionKey;
import io.confluent.dekregistry.storage.KeyEncryptionKeyId;
import io.confluent.dekregistry.web.rest.exceptions.RestConflictException;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RetryExecutor;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.rest.client.LocalSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.storage.CloseableIterator;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.ConfigValue;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectKey;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectValue;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.SubjectKey;
import io.confluent.kafka.schemaregistry.storage.SubjectValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.exceptions.RestNotFoundException;
import io.confluent.schema.exporter.client.rest.entities.ExporterInfo;
import io.confluent.schema.exporter.metrics.MetricDescriptor;
import io.confluent.schema.exporter.metrics.MetricTags;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterClientConfig;
import io.confluent.schema.exporter.storage.SchemaExporterInfo;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import io.confluent.schema.exporter.storage.utils.LocalDekRegistryClient;
import io.confluent.schema.exporter.util.StripedRunnable;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaExporterTask
implements StripedRunnable {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaExporterTask.class);
    public static final int DEFAULT_MAX_DEKS = 1000;
    public static final int DEFAULT_MAX_SCHEMAS_PER_SUBJECT = 1000;
    public static final String MAX_SCHEMAS_PER_SUBJECT = "max.schemas.per.subject";
    public static final int BATCH_SIZE = 100;
    public static final String ENCRYPT = "ENCRYPT";
    public static final String ENCRYPT_PAYLOAD = "ENCRYPT_PAYLOAD";
    public static final String ENCRYPT_KEK_NAME = "encrypt.kek.name";
    private static final String AWS_ALIAS_PREFIX = "alias/";
    private static final String AWS_MULTI_REGION_KEY_PREFIX = "key/mrk-";
    private static final String KEK_VAR = "${kek}";
    private static final String SUBJECT_VAR = "${subject}";
    private final SchemaExporterService exporterService;
    private final KafkaSchemaRegistry schemaRegistry;
    private final DekRegistry dekRegistry;
    private final SchemaExporter exporter;
    private final RetryExecutor retryExecutor;

    public AbstractSchemaExporterTask(SchemaExporterService exporterService, SchemaExporter exporter) {
        this.exporterService = exporterService;
        this.schemaRegistry = exporterService.getSchemaRegistry();
        this.dekRegistry = (DekRegistry)this.schemaRegistry.properties().get("dekRegistry");
        this.exporter = exporter;
        this.retryExecutor = new RetryExecutor(exporterService.config().exporterMaxRetries(), exporterService.config().exporterRetriesWaitMs(), exporterService.config().exporterRetriesMaxWaitMs());
    }

    public SchemaExporterService exporterService() {
        return this.exporterService;
    }

    public KafkaSchemaRegistry schemaRegistry() {
        return this.schemaRegistry;
    }

    public DekRegistry dekRegistry() {
        return this.dekRegistry;
    }

    public SchemaExporter exporter() {
        return this.exporter;
    }

    public String tenant() {
        return this.exporter.getTenant();
    }

    @Override
    public Object getStripe() {
        return this.tenant();
    }

    @Override
    public abstract void run();

    protected SchemaRegistryClient getSchemaRegistryClient(Map<String, String> config) {
        SchemaExporterClientConfig clientConfig = this.exporterService().encoder().clientConfig(config);
        Map properties = clientConfig.originals();
        Map<String, String> httpHeaders = this.exporterService().getHttpHeaders(properties);
        int exporterMaxCacheCapacity = this.exporterService().config().exporterMaxCacheCapacity();
        log.debug("Found exporter max cache capacity in schema registry config: {}", (Object)exporterMaxCacheCapacity);
        Object maxSchemasPerSubjectObj = properties.get(MAX_SCHEMAS_PER_SUBJECT);
        int maxSchemasPerSubject = AbstractSchemaExporterTask.computeMaxSchemasPerSubject(maxSchemasPerSubjectObj, exporterMaxCacheCapacity);
        log.debug("SR client cache capacity: {}", (Object)maxSchemasPerSubject);
        List<SchemaProvider> providers = Arrays.asList(new AvroSchemaProvider(), new JsonSchemaProvider(), new ProtobufSchemaProvider());
        List<String> urlList = this.exporterService().getSchemaRegistryUrls(properties);
        if (urlList.size() == 1 && urlList.get(0).startsWith("local:///")) {
            return new LocalSchemaRegistryClient(this.schemaRegistry(), providers);
        }
        return new CachedSchemaRegistryClient(urlList, maxSchemasPerSubject, providers, properties, httpHeaders);
    }

    public static int computeMaxSchemasPerSubject(Object maxSchemasPerSubjectObj, int exporterMaxCacheCapacity) {
        int maxSchemasPerSubject = 1000;
        if (maxSchemasPerSubjectObj == null) {
            maxSchemasPerSubject = Math.min(exporterMaxCacheCapacity, 1000);
        } else {
            try {
                int msps = Integer.parseInt(maxSchemasPerSubjectObj.toString());
                maxSchemasPerSubject = Math.min(exporterMaxCacheCapacity, msps);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return maxSchemasPerSubject;
    }

    protected static boolean isLocal(SchemaRegistryClient client) {
        return client instanceof LocalSchemaRegistryClient;
    }

    protected static boolean isLocal(DekRegistryClient client) {
        return client instanceof LocalDekRegistryClient;
    }

    protected DekRegistryClient getDekRegistryClient(Map<String, String> config) {
        SchemaExporterClientConfig clientConfig = this.exporterService().encoder().clientConfig(config);
        Map properties = clientConfig.originals();
        List<String> urlList = this.exporterService().getSchemaRegistryUrls(properties);
        Map<String, String> httpHeaders = this.exporterService().getHttpHeaders(properties);
        if (urlList.size() == 1 && urlList.get(0).startsWith("local:///")) {
            return new LocalDekRegistryClient(this.dekRegistry());
        }
        return new CachedDekRegistryClient(urlList, 1000, -1, properties, httpHeaders);
    }

    protected boolean matches(List<String> subjects, String subject) {
        for (String subjectOrPrefix : subjects) {
            if (!this.matches(subjectOrPrefix, subject)) continue;
            return true;
        }
        return false;
    }

    protected boolean matches(String subjectOrPrefix, String subject) {
        boolean isPrefix = subjectOrPrefix.endsWith("*");
        if (isPrefix) {
            String prefix = subjectOrPrefix.substring(0, subjectOrPrefix.length() - 1);
            boolean isDefaultContextPrefix = prefix.equals(":.:");
            if (isDefaultContextPrefix) {
                return !subject.startsWith(":.");
            }
            return subject.startsWith(this.removeDefaultContext(prefix));
        }
        if (subjectOrPrefix.equals(":*:")) {
            return true;
        }
        return subject.equals(this.removeDefaultContext(subjectOrPrefix));
    }

    private String removeDefaultContext(String subjectOrPrefix) {
        String ctx = ":.:";
        return subjectOrPrefix.startsWith(ctx) ? subjectOrPrefix.substring(ctx.length()) : subjectOrPrefix;
    }

    public static String trace(Throwable t) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            t.printStackTrace(new PrintStream((OutputStream)output, false, StandardCharsets.UTF_8.name()));
            return output.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    protected boolean isRetriable(Throwable t) {
        if (t instanceof RestClientException) {
            return AbstractSchemaExporterTask.isRetriable((RestClientException)t);
        }
        return t instanceof IOException || t instanceof OutOfMemoryError;
    }

    public static boolean isRetriable(RestClientException e) {
        int status = e.getStatus();
        boolean isClientErrorToIgnore = status == 408 || status == 429;
        boolean isServerErrorToIgnore = status == 500 || status == 502 || status == 503 || status == 504;
        return isClientErrorToIgnore || isServerErrorToIgnore;
    }

    protected SubjectValue exportValues(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String subjectOrPrefix, long exclusiveStartOffset, long exclusiveEndOffset, boolean checkMode, int totalSubjects, int subjectIndex) throws SchemaRegistryException, IOException, RestClientException {
        String tenantPrefix = this.tenant().equals("default") ? "" : this.tenant() + "_";
        boolean isPrefix = subjectOrPrefix.endsWith("*");
        KeyValue<String, String> range = this.getRange(subjectOrPrefix, tenantPrefix, isPrefix);
        String start = (String)range.key;
        String end = (String)range.value;
        List<SchemaRegistryValue> prevValues = this.getValuesWithSubjectPrefix(start, end, exclusiveStartOffset, exclusiveEndOffset);
        int totalValues = prevValues.size();
        log.info("{}: Found {} subjects to export for subject pattern {}", new Object[]{exporter, totalValues, subjectOrPrefix});
        SubjectValue subjectValue = null;
        int valuesExported = 0;
        for (SchemaRegistryValue prevValue : prevValues) {
            subjectValue = (SubjectValue)prevValue;
            String subject = subjectValue.getSubject();
            boolean doExport = false;
            if (!tenantPrefix.isEmpty()) {
                if (subject.startsWith(tenantPrefix)) {
                    subject = subject.substring(tenantPrefix.length());
                    doExport = true;
                }
            } else {
                doExport = true;
            }
            if (!doExport || !this.matches(subjectOrPrefix, subject)) continue;
            log.info("{}: Exporting {} out of {} possible subjects", new Object[]{exporter, valuesExported + 1, totalValues});
            int subjectWeight = 100 / totalSubjects;
            int completed = subjectWeight * subjectIndex;
            this.exportValue(exporter, client, info, status, subjectValue, checkMode);
            this.updateStartingProgressGauge(this.exporter(), status, ++valuesExported, totalValues, subjectWeight, completed);
            SchemaExporterStatus currentStatus = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)exporter);
            if (currentStatus == null || currentStatus.getState() != SchemaExporterStatus.State.STARTING || valuesExported % 100 != 0) continue;
            currentStatus.setObjectsExported(currentStatus.getObjectsExported() + 100L);
            this.saveStatus(exporter, currentStatus);
        }
        SchemaExporterStatus finalStatus = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)exporter);
        if (finalStatus != null && valuesExported > 0) {
            finalStatus.setObjectsExported(finalStatus.getObjectsExported() + (long)(valuesExported % 100));
            this.saveStatus(exporter, finalStatus);
        }
        return subjectValue;
    }

    private KeyValue<String, String> getRange(String subjectOrPrefix, String tenantPrefix, boolean isPrefix) {
        String end;
        Object start;
        if (isPrefix) {
            String prefix = subjectOrPrefix.substring(0, subjectOrPrefix.length() - 1);
            boolean isDefaultContextPrefix = prefix.equals(":.:");
            if (isDefaultContextPrefix) {
                start = tenantPrefix;
                end = tenantPrefix + "\uffff";
            } else {
                start = tenantPrefix + this.removeDefaultContext(prefix);
                end = (String)start + "\uffff";
            }
        } else if (subjectOrPrefix.equals(":*:")) {
            start = tenantPrefix + ":.:";
            end = tenantPrefix + ":.\uffff:";
        } else {
            start = tenantPrefix + this.removeDefaultContext(subjectOrPrefix);
            end = start;
        }
        return new KeyValue(start, (Object)end);
    }

    protected void saveStatus(SchemaExporter exporter, SchemaExporterStatus status) {
        SchemaExporterStatus oldStatus = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)exporter);
        if (oldStatus != null && oldStatus.getState() == SchemaExporterStatus.State.STARTING && status.getState() == SchemaExporterStatus.State.RUNNING) {
            MetricName exporterStartingProgressGauge = MetricTags.buildMetricNameWithTenant(MetricDescriptor.EXPORTER_STARTING_PROGRESS, exporter.getTenant(), exporter.getName());
            this.exporterService().metricsManager.getTenantMetrics(exporter.getTenant()).getGauge(exporterStartingProgressGauge).set(100L);
        }
        this.exporterService().exporterStatuses().put((Object)exporter, (Object)status);
        this.exporterService().metricsManager.getTenantMetrics((String)exporter.getTenant()).exporterStatusGauges.addExporterStatus(exporter, status);
    }

    protected void saveStatus(SubjectValue lastSubjectValue, EncryptionKey lastEncryptionKey, boolean isDone) {
        SchemaExporterStatus status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter());
        if (status != null) {
            if (status.getState() == SchemaExporterStatus.State.STARTING && isDone) {
                status.setState(SchemaExporterStatus.State.RUNNING);
            }
            status.setTrace(null);
            status.setRetriable(false);
            if (lastSubjectValue != null && lastSubjectValue.getOffset() > status.getOffset()) {
                status.setOffset(lastSubjectValue.getOffset());
                status.setTimestamp(lastSubjectValue.getTimestamp());
            }
            if (lastEncryptionKey != null && lastEncryptionKey.getOffset() > status.getDeksOffset()) {
                status.setDeksOffset(lastEncryptionKey.getOffset());
                status.setDeksTimestamp(lastEncryptionKey.getTimestamp());
            }
            this.saveStatus(this.exporter(), status);
            log.info("Updated {}, offset {}", (Object)this.exporter(), (Object)status.getOffset());
        }
    }

    private void exportValue(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, SubjectValue prevValue, boolean checkMode) throws IOException, RestClientException {
        SubjectKey key = prevValue.toKey();
        this.export(exporter, client, info, status, this.tenant(), key, prevValue, checkMode);
    }

    protected void export(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String tenant, SubjectKey key, SubjectValue value, boolean checkMode) throws IOException, RestClientException {
        QualifiedSubject qs = QualifiedSubject.create((String)tenant, (String)key.getSubject());
        String contextWithoutTenant = ":" + qs.getContext() + ":" + qs.getSubject();
        String newSubject = AbstractSchemaExporterTask.translateSubject(this.schemaRegistry(), AbstractSchemaExporterTask.isLocal(client), info, tenant, contextWithoutTenant);
        if (newSubject == null) {
            log.info("{}: Skipping subject {} as new subject is null", (Object)exporter, (Object)key.getSubject());
            return;
        }
        switch (key.getKeyType()) {
            case SCHEMA: {
                if (checkMode) {
                    this.setMode(exporter, client, info, tenant, key);
                }
                log.info("{}: Copying schema for subject {} to destination subject {}", new Object[]{exporter, key.getSubject(), newSubject});
                this.exportSchema(exporter, client, info, status, tenant, newSubject, (SchemaKey)key, (SchemaValue)value);
                if (value == null || !((SchemaValue)value).isDeleted()) break;
                this.setMode(exporter, client, info, tenant, key);
                break;
            }
            case CONFIG: {
                log.info("{}: Copying config for subject {} to destination subject {}", new Object[]{exporter, key.getSubject(), newSubject});
                this.exportConfig(exporter, client, info, status, tenant, newSubject, (ConfigKey)key, (ConfigValue)value);
                break;
            }
            case DELETE_SUBJECT: {
                log.info("{}: Deleting subject {} in destination cluster subject {}", new Object[]{exporter, key.getSubject(), newSubject});
                this.exportDeleteSubject(exporter, client, info, status, tenant, newSubject, (DeleteSubjectKey)key, (DeleteSubjectValue)value);
                this.setMode(exporter, client, info, tenant, key);
                break;
            }
            default: {
                log.info("{}: Ignoring key type {}", (Object)exporter, (Object)key.getKeyType());
            }
        }
    }

    protected EncryptionKey exportKeys(SchemaExporter exporter, DekRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String subjectOrPrefix, long exclusiveStartOffset, long exclusiveEndOffset) throws IOException, RestClientException {
        String tenantPrefix = "";
        boolean isPrefix = subjectOrPrefix.endsWith("*");
        KeyValue<String, String> range = this.getRange(subjectOrPrefix, tenantPrefix, isPrefix);
        String start = (String)range.key;
        String end = (String)range.value;
        List<DataEncryptionKey> prevKeys = this.getKeysWithSubjectPrefix(start, end, exclusiveStartOffset, exclusiveEndOffset);
        DataEncryptionKey key = null;
        int count = 0;
        for (DataEncryptionKey dek : prevKeys) {
            ++count;
            key = dek;
            if (!this.matches(subjectOrPrefix, dek.getSubject())) continue;
            KeyEncryptionKey kek = this.dekRegistry().getKek(dek.getKekName(), true);
            log.info("{}: processing dek/kek {}. Count {} out of {}", new Object[]{exporter, dek.getSubject(), count, prevKeys.size()});
            this.exportKek(exporter, client, info, status, kek);
            this.exportDek(exporter, client, info, status, dek);
        }
        return key;
    }

    private void exportKek(SchemaExporter exporter, DekRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, KeyEncryptionKey kek) throws IOException, RestClientException {
        this.exportKek(exporter, client, info, status, this.tenant(), kek.toKey(this.tenant()), kek);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void exportKek(SchemaExporter exporter, DekRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String tenant, KeyEncryptionKeyId kekId, KeyEncryptionKey kek) throws IOException, RestClientException {
        String newKekName = AbstractSchemaExporterTask.rename(info.getKekRenameFormat(), KEK_VAR, kekId.getName());
        if (kek == null) {
            try {
                log.info("{}: Hard-deleting kek {}", (Object)this.exporter(), (Object)newKekName);
                this.retryExecutor.retry(() -> {
                    client.deleteKek(newKekName, true);
                    return true;
                });
                MetricName opMetric = MetricTags.buildOperationMetricName(this.tenant(), exporter.getName(), "kek", "delete");
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(opMetric).increment(1L);
                return;
            }
            catch (RestNotFoundException e) {
                log.info("{}: Hard-deleting kek {} (NOT_FOUND)", (Object)this.exporter(), (Object)newKekName);
                MetricName errorMetric = MetricTags.buildErrorMetricName(tenant, exporter.getName(), "deleteKek", ((Object)((Object)e)).getClass().getSimpleName() + "_" + e.getStatus());
                this.exporterService().metricsManager.getTenantMetrics(tenant).getCounter(errorMetric).increment(1L);
                return;
            }
            catch (RestClientException e) {
                if (e.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) return;
                MetricName errorMetric = MetricTags.buildErrorMetricName(tenant, exporter.getName(), "deleteKek", ((Object)((Object)e)).getClass().getSimpleName() + "_" + e.getStatus());
                this.exporterService().metricsManager.getTenantMetrics(tenant).getCounter(errorMetric).increment(1L);
                throw e;
            }
        }
        if (!newKekName.equals(kekId.getName())) {
            kek = new KeyEncryptionKey(newKekName, kek.getKmsType(), kek.getKmsKeyId(), kek.getKmsProps(), kek.getDoc(), kek.isShared(), kek.isDeleted());
        }
        try {
            this.registerKek(exporter, client, kek);
            MetricName opMetric = MetricTags.buildOperationMetricName(this.tenant(), exporter.getName(), "kek", "export");
            this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(opMetric).increment(1L);
            return;
        }
        catch (RestConflictException e) {
            log.info("{}: Registering kek {} (CONFLICT)", (Object)this.exporter(), (Object)newKekName);
            this.maybeUpdateKek(exporter, client, kek, (Exception)((Object)e));
            MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "registerKek", ((Object)((Object)e)).getClass().getSimpleName() + "_" + e.getStatus());
            this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
            return;
        }
        catch (RestClientException e) {
            if (e.getStatus() != Response.Status.CONFLICT.getStatusCode()) {
                MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "registerKek", ((Object)((Object)e)).getClass().getSimpleName());
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
                throw e;
            }
            log.info("{}: Registering kek {} (CONFLICT)", (Object)this.exporter(), (Object)newKekName);
            this.maybeUpdateKek(exporter, client, kek, (Exception)((Object)e));
        }
    }

    private void registerKek(SchemaExporter exporter, DekRegistryClient client, KeyEncryptionKey kek) throws IOException, RestClientException {
        log.info("{}: Registering kek {}", (Object)this.exporter(), (Object)kek.getName());
        this.retryExecutor.retry(() -> client.createKek(kek.getName(), kek.getKmsType(), kek.getKmsKeyId(), (Map)kek.getKmsProps(), kek.getDoc(), kek.isShared(), kek.isDeleted()));
    }

    private void maybeUpdateKek(SchemaExporter exporter, DekRegistryClient client, KeyEncryptionKey kek, Exception e) throws IOException, RestClientException {
        Kek oldKek = (Kek)this.retryExecutor.retry(() -> client.getKek(kek.getName(), true));
        if (AbstractSchemaExporterTask.areKeyIdsEquivalent(kek.getKmsKeyId(), oldKek.getKmsKeyId()) && kek.getKmsType().equals(oldKek.getKmsType())) {
            if (!(Objects.equals(kek.getKmsProps(), oldKek.getKmsProps()) && Objects.equals(kek.getDoc(), oldKek.getDoc()) && Objects.equals(kek.isShared(), oldKek.isShared()))) {
                this.updateKek(exporter, client, kek);
            }
        } else {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RestClientException) {
                throw (RestClientException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public static boolean areKeyIdsEquivalent(String kmsKeyId1, String kmsKeyId2) {
        if (kmsKeyId1.startsWith("arn:") && kmsKeyId2.startsWith("arn:")) {
            List tokens1 = Splitter.on((char)':').splitToList((CharSequence)kmsKeyId1);
            List tokens2 = Splitter.on((char)':').splitToList((CharSequence)kmsKeyId2);
            if (tokens1.size() == 6 && tokens2.size() == 6) {
                String accountId1 = (String)tokens1.get(4);
                String accountId2 = (String)tokens2.get(4);
                String keyName1 = (String)tokens1.get(5);
                String keyName2 = (String)tokens2.get(5);
                if (keyName1.startsWith(AWS_ALIAS_PREFIX) && keyName2.startsWith(AWS_ALIAS_PREFIX) || keyName1.startsWith(AWS_MULTI_REGION_KEY_PREFIX) && keyName2.startsWith(AWS_MULTI_REGION_KEY_PREFIX)) {
                    return accountId1.equals(accountId2) && keyName1.equals(keyName2);
                }
            }
        }
        return kmsKeyId1.equals(kmsKeyId2);
    }

    private void updateKek(SchemaExporter exporter, DekRegistryClient client, KeyEncryptionKey kek) throws IOException, RestClientException {
        log.info("{}: Updating kek {}", (Object)this.exporter(), (Object)kek.getName());
        this.retryExecutor.retry(() -> client.updateKek(kek.getName(), (Map)kek.getKmsProps(), kek.getDoc(), Boolean.valueOf(kek.isShared())));
        MetricName opMetric = MetricTags.buildOperationMetricName(this.tenant(), exporter.getName(), "kek", "update");
        this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(opMetric).increment(1L);
    }

    protected void deleteKek(SchemaExporter exporter, DekRegistryClient client, SchemaExporterInfo info, KeyEncryptionKeyId kekId, KeyEncryptionKey kek) throws IOException, RestClientException {
        block3: {
            String newKekName = AbstractSchemaExporterTask.rename(info.getKekRenameFormat(), KEK_VAR, kekId.getName());
            try {
                log.info("{}: Soft-deleting kek {}", (Object)exporter, (Object)newKekName);
                this.retryExecutor.retry(() -> {
                    client.deleteKek(newKekName, false);
                    return true;
                });
                MetricName opMetric = MetricTags.buildOperationMetricName(this.tenant(), exporter.getName(), "kek", "delete");
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(opMetric).increment(1L);
            }
            catch (RestNotFoundException e) {
                log.info("{}: Soft-deleting kek {} ignoring because of NOT_FOUND", (Object)this.exporter(), (Object)newKekName);
                MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "deleteKek", ((Object)((Object)e)).getClass().getSimpleName() + "_" + e.getStatus());
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
            }
            catch (RestClientException e) {
                if (e.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) break block3;
                MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "deleteKek", ((Object)((Object)e)).getClass().getSimpleName() + "_" + e.getStatus());
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
                throw e;
            }
        }
    }

    private void exportDek(SchemaExporter exporter, DekRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, DataEncryptionKey dek) throws IOException, RestClientException {
        this.exportDek(exporter, client, info, status, this.tenant(), dek.toKey(this.tenant()), dek);
    }

    protected void exportDek(SchemaExporter exporter, DekRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String tenant, DataEncryptionKeyId dekId, DataEncryptionKey dek) throws IOException, RestClientException {
        String newKekName = AbstractSchemaExporterTask.rename(info.getKekRenameFormat(), KEK_VAR, dekId.getKekName());
        String subject = dekId.getSubject();
        String newSubject = AbstractSchemaExporterTask.translateSubject(this.schemaRegistry(), AbstractSchemaExporterTask.isLocal(client), info, tenant, subject);
        if (newSubject == null) {
            log.debug("Skipping subject " + subject);
            return;
        }
        if (!newKekName.equals(dekId.getKekName()) || !newSubject.equals(dekId.getSubject())) {
            dekId = new DataEncryptionKeyId(dekId.getTenant(), newKekName, newSubject, dekId.getAlgorithm(), dekId.getVersion());
            if (dek != null) {
                dek = new DataEncryptionKey(newKekName, newSubject, dek.getAlgorithm(), dek.getVersion(), dek.getEncryptedKeyMaterial(), dek.isDeleted());
            }
        }
        this.exportDek(exporter, client, status, dekId, dek);
    }

    private void exportDek(SchemaExporter exporter, DekRegistryClient client, SchemaExporterStatus status, DataEncryptionKeyId dekId, DataEncryptionKey dek) throws IOException, RestClientException {
        if (dek == null) {
            try {
                log.info("{}: Deleting dek {}", (Object)exporter, (Object)dekId.getSubject());
                this.retryExecutor.retry(() -> {
                    client.deleteDekVersion(dekId.getKekName(), dekId.getSubject(), dekId.getVersion(), dekId.getAlgorithm(), true);
                    return true;
                });
                MetricName opMetric = MetricTags.buildOperationMetricName(this.tenant(), exporter.getName(), "dek", "delete");
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(opMetric).increment(1L);
            }
            catch (RestNotFoundException e) {
                log.info("{}: Deleting dek {} ignoring because of NOT_FOUND", (Object)this.exporter(), (Object)dekId.getSubject());
                MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "deleteDek", ((Object)((Object)e)).getClass().getSimpleName() + "_" + e.getStatus());
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
            }
            catch (RestClientException e) {
                if (e.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                    MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "deleteDek", ((Object)((Object)e)).getClass().getSimpleName());
                    this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
                    throw e;
                }
                log.info("{}: Deleting dek {} ignoring because of (NOT_FOUND)", (Object)this.exporter(), (Object)dekId.getSubject());
            }
        } else {
            try {
                this.registerDek(exporter, client, dek);
                MetricName opMetric = MetricTags.buildOperationMetricName(this.tenant(), exporter.getName(), "dek", "export");
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(opMetric).increment(1L);
            }
            catch (RestConflictException e) {
                log.info("{}: Registering dek {} (CONFLICT)", (Object)this.exporter(), (Object)dekId.getSubject());
                MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "registerDek", ((Object)((Object)e)).getClass().getSimpleName() + "_" + e.getStatus());
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
            }
            catch (RestClientException e) {
                if (e.getStatus() != Response.Status.CONFLICT.getStatusCode()) {
                    MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "registerDek", ((Object)((Object)e)).getClass().getSimpleName());
                    this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
                    throw e;
                }
                log.info("{}: Registering dek {} (CONFLICT)", (Object)this.exporter(), (Object)dekId.getSubject());
            }
        }
    }

    private void registerDek(SchemaExporter exporter, DekRegistryClient client, DataEncryptionKey dek) throws IOException, RestClientException {
        log.info("{}: Registering dek {}", (Object)this.exporter(), (Object)dek.getSubject());
        this.retryExecutor.retry(() -> client.createDek(dek.getKekName(), dek.getSubject(), dek.getVersion(), dek.getAlgorithm(), dek.getEncryptedKeyMaterial(), dek.isDeleted()));
    }

    private void setMode(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, String tenant, SubjectKey key) throws IOException, RestClientException {
        QualifiedSubject qs = QualifiedSubject.create((String)tenant, (String)key.getSubject());
        String contextWithoutTenant = ":" + qs.getContext() + ":" + qs.getSubject();
        String newSubject = AbstractSchemaExporterTask.translateSubject(this.schemaRegistry(), AbstractSchemaExporterTask.isLocal(client), info, tenant, contextWithoutTenant);
        if (newSubject != null) {
            log.info("{}: Setting mode for context {}", (Object)this.exporter(), (Object)contextWithoutTenant);
            this.setMode(exporter, client, newSubject, true);
        } else {
            log.info("{}: Skipping setting mode for context {} because new subject is null", (Object)this.exporter(), (Object)contextWithoutTenant);
        }
    }

    protected void setMode(SchemaExporter exporter, SchemaRegistryClient client, String context, boolean force) throws IOException, RestClientException {
        String mode = null;
        try {
            mode = (String)this.retryExecutor.retry(() -> client.getMode(context));
        }
        catch (RestNotFoundException e) {
            log.info("{}: Setting mode for context {} ignoring because of NOT_FOUND", (Object)this.exporter(), (Object)context);
            MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "setMode", ((Object)((Object)e)).getClass().getSimpleName() + "_" + e.getStatus());
            this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
        }
        catch (RestClientException e) {
            if (e.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "setMode", ((Object)((Object)e)).getClass().getSimpleName() + "_" + e.getStatus());
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
                throw e;
            }
            log.info("{}: Setting mode for context {} ignoring because of (NOT_FOUND)", (Object)this.exporter(), (Object)context);
        }
        boolean isReady = Mode.IMPORT.name().equalsIgnoreCase(mode);
        if (!isReady) {
            log.info("{}: Setting mode for context {}", (Object)exporter, (Object)context);
            this.retryExecutor.retry(() -> client.setMode(Mode.IMPORT.name(), context, force));
        }
    }

    private void exportSchema(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String tenant, String subject, SchemaKey key, SchemaValue value) throws IOException, RestClientException {
        if (value == null) {
            try {
                log.info("Hard-deleting schema for {}", (Object)exporter);
                this.retryExecutor.retry(() -> client.deleteSchemaVersion(subject, String.valueOf(key.getVersion()), true));
                MetricName opMetric = MetricTags.buildOperationMetricName(tenant, exporter.getName(), "schema", "delete");
                this.exporterService().metricsManager.getTenantMetrics(tenant).getCounter(opMetric).increment(1L);
            }
            catch (RestNotFoundException e) {
                log.info("{}: Hard-deleting schema for {} ignoring because of NOT_FOUND", (Object)this.exporter(), (Object)subject);
                MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "hardDeleteSchema", ((Object)((Object)e)).getClass().getSimpleName() + "_" + e.getStatus());
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
            }
            catch (RestClientException e) {
                if (e.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                    MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "hardDeleteSchema", ((Object)((Object)e)).getClass().getSimpleName());
                    this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
                    throw e;
                }
                log.info("{}: Hard-deleting schema for {} ignoring because of (NOT_FOUND)", (Object)this.exporter(), (Object)subject);
            }
        } else if (value.isDeleted()) {
            MetricName errorMetric;
            block15: {
                if (status.getState() == SchemaExporterStatus.State.STARTING) {
                    try {
                        this.retryExecutor.retry(() -> client.getByVersion(subject, key.getVersion(), true));
                    }
                    catch (Exception e) {
                        Throwable cause = e.getCause();
                        MetricName errorMetric2 = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "getByVersion", e.getClass().getSimpleName());
                        this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric2).increment(1L);
                        if (!(cause instanceof RestClientException) || ((RestClientException)cause).getStatus() != Response.Status.NOT_FOUND.getStatusCode()) break block15;
                        this.registerSchema(exporter, info, client, subject, value);
                    }
                }
            }
            try {
                log.info("Deleting schema for {}", (Object)exporter);
                this.retryExecutor.retry(() -> client.deleteSchemaVersion(subject, String.valueOf(key.getVersion())));
                MetricName opMetric = MetricTags.buildOperationMetricName(tenant, exporter.getName(), "schema", "delete");
                this.exporterService().metricsManager.getTenantMetrics(tenant).getCounter(opMetric).increment(1L);
            }
            catch (RestNotFoundException e) {
                log.info("{}: Deleting schema for {} ignoring because of NOT_FOUND", (Object)this.exporter(), (Object)subject);
                errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "deleteSchema", ((Object)((Object)e)).getClass().getSimpleName() + "_" + e.getStatus());
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
            }
            catch (RestClientException e) {
                if (e.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                    errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "deleteSchema", ((Object)((Object)e)).getClass().getSimpleName());
                    this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
                    throw e;
                }
                log.info("{}: Deleting schema for {} ignoring because of (NOT_FOUND)", (Object)this.exporter(), (Object)subject);
            }
        } else {
            this.registerSchema(exporter, info, client, subject, value);
            MetricName opMetric = MetricTags.buildOperationMetricName(tenant, exporter.getName(), "schema", "export");
            this.exporterService().metricsManager.getTenantMetrics(tenant).getCounter(opMetric).increment(1L);
            this.incrementSchemaTransferSuccess(exporter);
        }
    }

    private void registerSchema(SchemaExporter exporter, SchemaExporterInfo info, SchemaRegistryClient client, String subject, SchemaValue value) throws IOException, RestClientException {
        Optional schema = null;
        try {
            schema = client.parseSchema(this.schemaRegistry.toSchemaEntity(value));
        }
        catch (SchemaRegistryStoreException schemaRegistryStoreException) {
            // empty catch block
        }
        if (schema == null || !schema.isPresent()) {
            throw new IOException("Could not parse schema " + value.getSchema() + " with type " + value.getSchemaType() + " with references " + String.valueOf(value.getReferences()));
        }
        ParsedSchema parsedSchema = (ParsedSchema)schema.get();
        if (info.getKekRenameFormat() != null && !info.getKekRenameFormat().isEmpty() && parsedSchema.ruleSet() != null && (parsedSchema.ruleSet().hasRulesWithType(ENCRYPT) || parsedSchema.ruleSet().hasRulesWithType(ENCRYPT_PAYLOAD))) {
            Metadata metadata = parsedSchema.metadata();
            Metadata newMetadata = this.renameKekInMetadata(info, metadata);
            RuleSet ruleSet = parsedSchema.ruleSet();
            RuleSet newRuleSet = this.renameKekInRules(info, ruleSet);
            parsedSchema = parsedSchema.copy(newMetadata, newRuleSet);
        }
        ParsedSchema finalSchema = parsedSchema;
        log.info("{}: Registering schema {}", (Object)this.exporter(), (Object)subject);
        this.retryExecutor.retry(() -> client.register(subject, finalSchema, value.getVersion().intValue(), value.getId().intValue()));
    }

    private Metadata renameKekInMetadata(SchemaExporterInfo info, Metadata metadata) {
        if (metadata == null || metadata.getProperties() == null || metadata.getProperties().isEmpty()) {
            return metadata;
        }
        return new Metadata((Map)metadata.getTags(), metadata.getProperties().entrySet().stream().map(e -> this.renameKekInProp(info, (Map.Entry<String, String>)e)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), (Set)metadata.getSensitive());
    }

    private Map.Entry<String, String> renameKekInProp(SchemaExporterInfo info, Map.Entry<String, String> entry) {
        if (!entry.getKey().equals(ENCRYPT_KEK_NAME)) {
            return entry;
        }
        String newKekName = AbstractSchemaExporterTask.rename(info.getKekRenameFormat(), KEK_VAR, entry.getValue());
        return new AbstractMap.SimpleEntry<String, String>(entry.getKey(), newKekName);
    }

    private RuleSet renameKekInRules(SchemaExporterInfo info, RuleSet ruleSet) {
        if (ruleSet == null) {
            return ruleSet;
        }
        List domainRules = ruleSet.getDomainRules() != null ? ruleSet.getDomainRules().stream().map(r -> this.renameKekInRule(info, (Rule)r)).collect(Collectors.toList()) : Collections.emptyList();
        List encodingRules = ruleSet.getEncodingRules() != null ? ruleSet.getEncodingRules().stream().map(r -> this.renameKekInRule(info, (Rule)r)).collect(Collectors.toList()) : Collections.emptyList();
        return new RuleSet(ruleSet.getMigrationRules(), domainRules, encodingRules);
    }

    private Rule renameKekInRule(SchemaExporterInfo info, Rule rule) {
        if (rule.getParams() == null || rule.getParams().isEmpty()) {
            return rule;
        }
        SortedMap params = rule.getParams();
        String kekName = (String)params.get(ENCRYPT_KEK_NAME);
        if (kekName == null) {
            return rule;
        }
        HashMap<String, String> newParams = new HashMap<String, String>(params);
        String newKekName = AbstractSchemaExporterTask.rename(info.getKekRenameFormat(), KEK_VAR, kekName);
        newParams.put(ENCRYPT_KEK_NAME, newKekName);
        return new Rule(rule.getName(), rule.getDoc(), rule.getKind(), rule.getMode(), rule.getType(), (Set)rule.getTags(), newParams, rule.getExpr(), rule.getOnSuccess(), rule.getOnFailure(), rule.isDisabled());
    }

    private void exportConfig(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String tenant, String subject, ConfigKey key, ConfigValue value) throws IOException, RestClientException {
        if (value == null) {
            try {
                log.info("{}: Deleting config for {}", (Object)this.exporter(), (Object)subject);
                this.retryExecutor.retry(() -> {
                    client.deleteConfig(subject);
                    return true;
                });
                MetricName opMetric = MetricTags.buildOperationMetricName(tenant, exporter.getName(), "config", "delete");
                this.exporterService().metricsManager.getTenantMetrics(tenant).getCounter(opMetric).increment(1L);
            }
            catch (RestNotFoundException e) {
                log.info("{}: Deleting config for {} ignoring because of NOT_FOUND", (Object)this.exporter(), (Object)subject);
                MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "deleteConfig", ((Object)((Object)e)).getClass().getSimpleName() + " NOT_FOUND");
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
            }
            catch (RestClientException e) {
                if (e.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                    MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "deleteConfig", ((Object)((Object)e)).getClass().getSimpleName());
                    this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
                    throw e;
                }
                log.info("{}: Deleting config for {} ignoring because of (NOT_FOUND)", (Object)this.exporter(), (Object)subject);
            }
        } else {
            log.info("{}: Updating config {}", (Object)this.exporter(), (Object)subject);
            this.retryExecutor.retry(() -> client.updateConfig(subject, value.toConfigEntity()));
            MetricName opMetric = MetricTags.buildOperationMetricName(tenant, exporter.getName(), "config", "update");
            this.exporterService().metricsManager.getTenantMetrics(tenant).getCounter(opMetric).increment(1L);
        }
    }

    private void exportDeleteSubject(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String tenant, String subject, DeleteSubjectKey key, DeleteSubjectValue value) throws IOException, RestClientException {
        try {
            log.info("{}: Deleting subject {}", (Object)this.exporter(), (Object)subject);
            this.retryExecutor.retry(() -> client.deleteSubject(subject));
            MetricName opMetric = MetricTags.buildOperationMetricName(tenant, exporter.getName(), "schema", "delete");
            this.exporterService().metricsManager.getTenantMetrics(tenant).getCounter(opMetric).increment(1L);
        }
        catch (RestNotFoundException e) {
            log.info("{}: Deleting subject {} ignoring because of NOT_FOUND", (Object)this.exporter(), (Object)subject);
            MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "deleteSubject", ((Object)((Object)e)).getClass().getSimpleName() + "_" + e.getStatus());
            this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
        }
        catch (RestClientException e) {
            if (e.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), exporter.getName(), "deleteSubject", ((Object)((Object)e)).getClass().getSimpleName());
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
                throw e;
            }
            log.info("{}: Deleting subject {} ignoring because of (NOT_FOUND)", (Object)this.exporter(), (Object)subject);
        }
    }

    public static String translateSubject(KafkaSchemaRegistry schemaRegistry, boolean isLocal, SchemaExporterInfo info, String tenant, String subjectWithoutTenant) {
        String relativeContext;
        Object newContext;
        QualifiedSubject qs = QualifiedSubject.create((String)"default", (String)subjectWithoutTenant);
        String newSubject = AbstractSchemaExporterTask.rename(info.getSubjectRenameFormat(), SUBJECT_VAR, qs.getSubject());
        if (CharMatcher.javaIsoControl().matchesAnyOf((CharSequence)newSubject)) {
            return null;
        }
        ExporterInfo.ContextType contextType = info.getContextType();
        if (contextType == null) {
            contextType = ExporterInfo.ContextType.AUTO;
        }
        String oldContext = qs.getContext();
        switch (contextType) {
            case NONE: {
                if (".".equals(oldContext)) {
                    return newSubject;
                }
                return ":" + oldContext + ":" + newSubject;
            }
            case AUTO: {
                newContext = SchemaExporterService.getAutoContext(schemaRegistry, tenant);
                break;
            }
            case CUSTOM: {
                newContext = info.getContext();
                break;
            }
            case DEFAULT: {
                if (isLocal && subjectWithoutTenant.equals(newSubject)) {
                    log.warn("Subject already in default context: " + newSubject);
                    return null;
                }
                return newSubject;
            }
            default: {
                throw new IllegalArgumentException("Unsupported context type " + String.valueOf((Object)contextType));
            }
        }
        if (((String)newContext).startsWith(".")) {
            relativeContext = ((String)newContext).substring(1);
        } else {
            relativeContext = newContext;
            newContext = "." + relativeContext;
        }
        if (!".".equals(oldContext)) {
            newContext = (String)newContext + oldContext;
            String[] parts = oldContext.split("\\.");
            if (Arrays.asList(parts).contains(relativeContext)) {
                log.warn("Avoiding cyclic context path: " + (String)newContext);
                return null;
            }
        }
        return ".".equals(newContext) ? newSubject : ":" + (String)newContext + ":" + newSubject;
    }

    public static String translateContext(KafkaSchemaRegistry schemaRegistry, boolean isLocal, SchemaExporterInfo info, String tenant, String subjectWithoutTenant) {
        String translatedSubject = AbstractSchemaExporterTask.translateSubject(schemaRegistry, isLocal, info, tenant, subjectWithoutTenant);
        if (translatedSubject == null) {
            return null;
        }
        QualifiedSubject qs = QualifiedSubject.create((String)"default", (String)translatedSubject);
        return qs.toUnqualifiedContext();
    }

    private static String rename(String renameFormat, String pattern, String oldName) {
        if (renameFormat == null || renameFormat.isEmpty()) {
            return oldName;
        }
        return renameFormat.replace(pattern, oldName);
    }

    private List<SchemaRegistryValue> getValuesWithSubjectPrefix(String start, String end, long exclusiveStartOffset, long exclusiveEndOffset) throws SchemaRegistryException {
        ArrayList<SchemaRegistryValue> values = new ArrayList<SchemaRegistryValue>();
        long maxOffset1 = this.getValues(this.configsWithSubjectPrefix(start, end), exclusiveStartOffset, exclusiveEndOffset, values);
        long maxOffset2 = this.getValues(this.deletesWithSubjectPrefix(start, end), exclusiveStartOffset, exclusiveEndOffset, values);
        long maxOffset3 = this.getValues(this.schemasWithSubjectPrefix(start, end), exclusiveStartOffset, exclusiveEndOffset, values);
        if (exclusiveEndOffset == Long.MAX_VALUE) {
            if (Math.max(maxOffset2, maxOffset3) > maxOffset1) {
                this.getValues(this.configsWithSubjectPrefix(start, end), Math.max(maxOffset1, exclusiveStartOffset), Math.max(maxOffset2, maxOffset3), values);
            }
            if (maxOffset3 > maxOffset2) {
                this.getValues(this.deletesWithSubjectPrefix(start, end), Math.max(maxOffset2, exclusiveStartOffset), maxOffset3, values);
            }
        }
        values.sort(Comparator.comparingLong(SchemaRegistryValue::getOffset));
        return values;
    }

    private long getValues(CloseableIterator<SchemaRegistryValue> iter, long exclusiveStartOffset, long exclusiveEndOffset, List<SchemaRegistryValue> values) throws SchemaRegistryException {
        long maxOffset = -1L;
        try (CloseableIterator<SchemaRegistryValue> schemas = iter;){
            while (schemas.hasNext()) {
                SchemaRegistryValue value = (SchemaRegistryValue)schemas.next();
                if (value.getOffset() <= exclusiveStartOffset || value.getOffset() >= exclusiveEndOffset) continue;
                values.add(value);
                if (value.getOffset() <= maxOffset) continue;
                maxOffset = value.getOffset();
            }
        }
        return maxOffset;
    }

    private CloseableIterator<SchemaRegistryValue> schemasWithSubjectPrefix(String start, String end) throws SchemaRegistryException {
        try {
            SchemaKey key1 = new SchemaKey(start, 1);
            SchemaKey key2 = new SchemaKey(end, Integer.MAX_VALUE);
            return this.schemaRegistry().getLookupCache().getAll((Object)key1, (Object)key2);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", (Throwable)e);
        }
    }

    private CloseableIterator<SchemaRegistryValue> deletesWithSubjectPrefix(String start, String end) throws SchemaRegistryException {
        try {
            LookupCache cache = this.schemaRegistry().getLookupCache();
            if (!start.equals(end)) {
                DeleteSubjectKey key1 = new DeleteSubjectKey(start);
                DeleteSubjectKey key2 = new DeleteSubjectKey(end);
                return cache.getAll((Object)key1, (Object)key2);
            }
            return new DelegatingIterator<SchemaRegistryValue>((SchemaRegistryValue)cache.get((Object)new DeleteSubjectKey(start)));
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", (Throwable)e);
        }
    }

    private CloseableIterator<SchemaRegistryValue> configsWithSubjectPrefix(String start, String end) throws SchemaRegistryException {
        try {
            LookupCache cache = this.schemaRegistry().getLookupCache();
            if (!start.equals(end)) {
                ConfigKey key1 = new ConfigKey(start);
                ConfigKey key2 = new ConfigKey(end);
                return cache.getAll((Object)key1, (Object)key2);
            }
            return new DelegatingIterator<SchemaRegistryValue>((SchemaRegistryValue)cache.get((Object)new ConfigKey(start)));
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", (Throwable)e);
        }
    }

    private List<DataEncryptionKey> getKeysWithSubjectPrefix(String start, String end, long exclusiveStartOffset, long exclusiveEndOffset) {
        if (this.dekRegistry() == null) {
            return Collections.emptyList();
        }
        ArrayList<DataEncryptionKey> deks = new ArrayList<DataEncryptionKey>();
        List kekNames = this.dekRegistry().getKekNames(null, true);
        for (String kekName : kekNames) {
            List<DataEncryptionKey> dekValues = this.getDekValues(this.deksWithSubjectPrefix(this.dekRegistry(), kekName, start, end), exclusiveStartOffset, exclusiveEndOffset);
            deks.addAll(dekValues);
        }
        deks.sort(Comparator.comparingLong(EncryptionKey::getOffset));
        return deks;
    }

    private List<DataEncryptionKey> getDekValues(KeyValueIterator<EncryptionKeyId, EncryptionKey> iter, long exclusiveStartOffset, long exclusiveEndOffset) {
        ArrayList<DataEncryptionKey> values = new ArrayList<DataEncryptionKey>();
        try (KeyValueIterator<EncryptionKeyId, EncryptionKey> deks = iter;){
            while (deks.hasNext()) {
                KeyValue value = (KeyValue)deks.next();
                long offset = ((EncryptionKey)value.value).getOffset();
                if (offset <= exclusiveStartOffset || offset >= exclusiveEndOffset) continue;
                values.add((DataEncryptionKey)value.value);
            }
        }
        return values;
    }

    private KeyValueIterator<EncryptionKeyId, EncryptionKey> deksWithSubjectPrefix(DekRegistry dekRegistry, String kekName, String start, String end) {
        DataEncryptionKeyId key1 = new DataEncryptionKeyId(this.tenant(), kekName, start, DekFormat.AES128_GCM, 1);
        DataEncryptionKeyId key2 = new DataEncryptionKeyId(this.tenant(), kekName, end, DekFormat.AES256_SIV, Integer.MAX_VALUE);
        return dekRegistry.keys().range((Object)key1, true, (Object)key2, false);
    }

    protected void updateStartingProgressGauge(SchemaExporter exporter, SchemaExporterStatus status, int schemasExported, int totalSchemas, int subjectWeight, int completed) {
        try {
            if (status.getState() == SchemaExporterStatus.State.STARTING) {
                int inSubject = subjectWeight * (schemasExported / totalSchemas);
                int progress = completed + inSubject;
                progress = Math.min(progress, 100);
                MetricName progressGauge = MetricTags.buildMetricNameWithTenant(MetricDescriptor.EXPORTER_STARTING_PROGRESS, this.tenant(), exporter.getName());
                this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getGauge(progressGauge).set(progress);
            }
        }
        catch (Exception e) {
            log.error("{}: Error {} updating metrics ", (Object)this.exporter(), (Object)e.getMessage());
        }
    }

    protected void incrementSchemaTransferSuccess(SchemaExporter exporter) {
        try {
            MetricName successCount = MetricTags.buildMetricNameWithTenant(MetricDescriptor.SCHEMA_TRANSFER_SUCCESS_TOTAL, this.tenant(), exporter.getName());
            this.exporterService().metricsManager.getTenantMetrics(this.tenant()).getCounter(successCount).increment(1L);
        }
        catch (Exception e) {
            log.error("{}: Error {} updating schema transfer success metric", (Object)this.exporter(), (Object)e.getMessage());
        }
    }

    static class DelegatingIterator<T>
    implements CloseableIterator<T> {
        private final Iterator<T> iterator;

        public DelegatingIterator(T value) {
            List coll = value != null ? Collections.singletonList(value) : Collections.emptyList();
            this.iterator = coll.iterator();
        }

        public DelegatingIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public T next() {
            return this.iterator.next();
        }

        public void remove() {
            this.iterator.remove();
        }

        public void close() {
        }
    }

    static class OffsetTimestamp {
        private final long offset;
        private final long timestamp;

        public OffsetTimestamp(long offset, long timestamp) {
            this.offset = offset;
            this.timestamp = timestamp;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OffsetTimestamp that = (OffsetTimestamp)o;
            return this.offset == that.offset && this.timestamp == that.timestamp;
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.timestamp);
        }

        public String toString() {
            return "OffsetTimestamp{offset=" + this.offset + ", timestamp=" + this.timestamp + "}";
        }
    }
}

