/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.dekregistry.storage.DekCacheUpdateHandler;
import io.confluent.dekregistry.storage.DekRegistry;
import io.confluent.dekregistry.storage.EncryptionKey;
import io.confluent.dekregistry.storage.EncryptionKeyId;
import io.confluent.schema.exporter.storage.AbstractSchemaExporterTask;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterInfo;
import io.confluent.schema.exporter.storage.SchemaExporterRunningTaskForKeys;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import io.confluent.schema.exporter.storage.SchemaExporterUpdateTaskForKeys;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DekExporterUpdateHandler
implements DekCacheUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(DekExporterUpdateHandler.class);
    public static final String DEK_EXPORT_HANDLER_KEY = "dekExportHandler";
    public static final String DEK_REGISTRY_KEY = "dekRegistry";
    private DekRegistry dekRegistry;
    private volatile SchemaExporterService exporterService;
    private final Set<SchemaExporter> exporters = ConcurrentHashMap.newKeySet();
    private final Map<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp> latestValues = new ConcurrentHashMap<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp>();
    private final Map<SchemaExporter, Integer> counts = new ConcurrentHashMap<SchemaExporter, Integer>();

    public void configure(Map<String, ?> configs) {
        this.dekRegistry = (DekRegistry)configs.get(DEK_REGISTRY_KEY);
        this.dekRegistry.getSchemaRegistry().properties().put(DEK_EXPORT_HANDLER_KEY, this);
        this.dekRegistry.getSchemaRegistry().properties().put(DEK_REGISTRY_KEY, this.dekRegistry);
    }

    public void cacheInitialized(int count, Map<TopicPartition, Long> checkpoints) {
    }

    public void startBatch(int count) {
    }

    public void setExporterService(SchemaExporterService exporterService) {
        this.exporterService = exporterService;
    }

    public void handleUpdate(EncryptionKeyId key, EncryptionKey value, EncryptionKey oldValue, TopicPartition tp, long offset, long timestamp) {
        if (this.dekRegistry.getSchemaRegistry().isLeader() && this.exporterService != null) {
            try (KeyValueIterator iter = this.exporterService.exporterInfos.all();){
                while (iter.hasNext()) {
                    KeyValue kv = (KeyValue)iter.next();
                    SchemaExporter exporter = (SchemaExporter)kv.key;
                    SchemaExporterInfo info = (SchemaExporterInfo)kv.value;
                    String name = info.getName();
                    SchemaExporterStatus status = (SchemaExporterStatus)this.exporterService.exporterStatuses.getOrDefault((Object)exporter, (Object)SchemaExporterService.newExporterStatus(name));
                    if (status.getState() != SchemaExporterStatus.State.RUNNING || status.getDeksOffset() >= offset) continue;
                    this.exporterService.submit(new SchemaExporterRunningTaskForKeys(this.exporterService, exporter, key, value, offset, timestamp, this.latestValues, this.counts, this.exporterService.metricsManager));
                    this.exporters.add(exporter);
                }
            }
        }
    }

    public void endBatch(int count) {
        if (this.dekRegistry.getSchemaRegistry().isLeader() && !this.exporters.isEmpty()) {
            for (SchemaExporter exporter : this.exporters) {
                this.exporterService.submit(new SchemaExporterUpdateTaskForKeys(this.exporterService, exporter, this.latestValues, this.counts));
            }
            this.exporters.clear();
        }
    }

    public void close() throws IOException {
    }
}

