/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaExporter
implements Comparable<SchemaExporter> {
    private String tenant;
    private String name;

    public SchemaExporter(@JsonProperty(value="tenant") String tenant, @JsonProperty(value="name") String name) {
        this.tenant = tenant;
        this.name = name;
    }

    @JsonProperty(value="tenant")
    public String getTenant() {
        return this.tenant;
    }

    @JsonProperty(value="tenant")
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaExporter that = (SchemaExporter)o;
        return this.tenant.equals(that.tenant) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.tenant, this.name);
    }

    @Override
    public int compareTo(SchemaExporter that) {
        if (this.tenant != null || that.tenant != null) {
            if (this.tenant == null) {
                return -1;
            }
            if (that.tenant == null) {
                return 1;
            }
            int tenantComparison = this.tenant.compareTo(that.tenant);
            if (tenantComparison != 0) {
                return tenantComparison < 0 ? -1 : 1;
            }
        }
        if (this.name == null && that.name == null) {
            return 0;
        }
        if (this.name == null) {
            return -1;
        }
        if (that.name == null) {
            return 1;
        }
        return this.name.compareTo(that.name);
    }

    public String toString() {
        return "Exporter{tenant='" + this.tenant + "', name='" + this.name + "'}";
    }

    public String getQualifiedName() {
        if (this.tenant == null || this.tenant.isEmpty()) {
            return this.name;
        }
        return this.tenant + ":" + this.name;
    }
}

