/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDeConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigDef;

public class SchemaExporterClientConfig
extends AbstractKafkaSchemaSerDeConfig {
    private static final ConfigDef clientConfig = SchemaExporterClientConfig.baseConfigDef();

    public SchemaExporterClientConfig(Map<?, ?> props) {
        super(clientConfig, props);
    }

    public Map<String, String> originalsStringsWithHiddenPasswords() {
        LinkedHashMap<String, String> copy = new LinkedHashMap<String, String>();
        for (Map.Entry entry : this.originals().entrySet()) {
            String key = (String)entry.getKey();
            Object value = this.typeOf(key) == ConfigDef.Type.PASSWORD ? this.getPassword(key) : entry.getValue();
            copy.put(key, Objects.toString(value));
        }
        return copy;
    }

    public static Optional<ConfigDef.Type> configType(String name) {
        return Optional.ofNullable((ConfigDef.ConfigKey)clientConfig.configKeys().get(name)).map(ConfigDef.ConfigKey::type);
    }
}

