/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import com.google.common.collect.ImmutableList;
import io.confluent.schema.exporter.storage.SchemaExporterClientConfig;
import io.confluent.schema.exporter.storage.SchemaExporterServerConfig;
import io.confluent.schema.exporter.storage.security.EncryptingPasswordEncoder;
import io.confluent.schema.exporter.storage.security.PasswordEncoder;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;

public class SchemaExporterClientConfigEncoder {
    private static final String PROVIDER_NAME = "encoder";
    private static final String PROVIDER_PARAM_PREFIX = "config.providers.encoder.param.";
    private static final String ENCRYPTED_CONFIG_PREFIX = "encrypted.";
    private final SchemaExporterServerConfig serverConfig;
    private final List<Encoder> encoders;

    public SchemaExporterClientConfigEncoder(SchemaExporterServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.encoders = SchemaExporterClientConfigEncoder.createEncoders(serverConfig.values());
    }

    public Map<String, String> encode(Map<String, String> exporterProps) {
        if (exporterProps == null) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        HashMap sensitiveProps = new HashMap();
        exporterProps.forEach((k, v) -> {
            Optional<ConfigDef.Type> propType = SchemaExporterClientConfig.configType(k);
            if (!propType.isPresent() || propType.get() == ConfigDef.Type.PASSWORD) {
                sensitiveProps.put(k, v);
                props.put((String)k, String.format("${%s:%s}", PROVIDER_NAME, k));
            } else {
                props.put((String)k, (String)v);
            }
        });
        if (!sensitiveProps.isEmpty()) {
            if (this.encoders.isEmpty()) {
                throw new InvalidConfigurationException("password.encoder.secret must be configured with sensitive or custom configs");
            }
            this.encoders.forEach(encoder -> {
                encoder.addEncodedProp("", encoder.secret, props);
                sensitiveProps.forEach((k, v) -> encoder.addEncodedProp((String)k, new Password(v), props));
            });
        }
        return props;
    }

    public Map<String, ?> decode(Map<String, String> persistentProps) {
        Map<String, String> providerProps = this.providerProperties(persistentProps, this.serverConfig);
        Properties encodedProps = new Properties();
        persistentProps.entrySet().stream().filter(e -> ((String)e.getKey()).equals("config.providers") || !providerProps.containsKey(e.getKey())).forEach(e -> encodedProps.put(e.getKey(), e.getValue()));
        HashMap decodedProps = new HashMap();
        new DecodingConfig(encodedProps, providerProps).originals().forEach(decodedProps::put);
        return decodedProps;
    }

    public SchemaExporterClientConfig clientConfig(Map<String, String> persistentProps) {
        Map<String, ?> decodedProps = this.decode(persistentProps);
        return new SchemaExporterClientConfig(decodedProps);
    }

    private Map<String, String> providerProperties(Map<String, String> persistentProps, SchemaExporterServerConfig serverConfig) {
        if (serverConfig.passwordEncoderSecret().isPresent()) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("config.providers", PROVIDER_NAME);
            props.put("config.providers.encoder.class", EncoderConfigProvider.class.getName());
            ConfigDef.convertToStringMapWithPasswordValues((Map)serverConfig.values()).entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("password.encoder.")).forEach(e -> props.put(PROVIDER_PARAM_PREFIX + (String)e.getKey(), (String)e.getValue()));
            persistentProps.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(PROVIDER_PARAM_PREFIX)).forEach(e -> props.put((String)e.getKey(), (String)e.getValue()));
            return props;
        }
        return Collections.emptyMap();
    }

    private static List<Encoder> createEncoders(Map<String, ?> configs) {
        return ImmutableList.of(SchemaExporterClientConfigEncoder.encoderSecret(configs, "password.encoder.secret").map(secret -> SchemaExporterClientConfigEncoder.createEncoder(configs, "secret.", secret)), SchemaExporterClientConfigEncoder.encoderSecret(configs, "password.encoder.old.secret").map(secret -> SchemaExporterClientConfigEncoder.createEncoder(configs, "old.secret.", secret))).stream().flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    private static Optional<Password> encoderSecret(Map<String, ?> configs, String configName) {
        return Optional.ofNullable(configs.get(configName)).map(secret -> {
            if (secret instanceof Password) {
                return (Password)secret;
            }
            if (secret instanceof String) {
                return new Password((String)secret);
            }
            throw new IllegalStateException("Unexpected password encoder secret type " + String.valueOf(secret.getClass()));
        });
    }

    private static Encoder createEncoder(Map<String, ?> configs, String secretPrefix, Password secret) {
        EncryptingPasswordEncoder passwordEncoder = PasswordEncoder.encrypting(secret, Optional.ofNullable(configs.get("password.encoder.keyfactory.algorithm")).map(Object::toString).orElse(null), configs.get("password.encoder.cipher.algorithm").toString(), Integer.parseInt(configs.get("password.encoder.key.length").toString()), Integer.parseInt(configs.get("password.encoder.iterations").toString()));
        return new Encoder(secretPrefix, secret, passwordEncoder);
    }

    private static class DecodingConfig
    extends AbstractConfig {
        public DecodingConfig(Map<Object, Object> props, Map<String, ?> configProviderProps) {
            super(new ConfigDef(), props, configProviderProps, false);
        }
    }

    public static class EncoderConfigProvider
    implements ConfigProvider {
        private final Map<String, String> configs = new HashMap<String, String>();

        public void configure(Map<String, ?> providerConfigs) {
            List<Encoder> encoders = SchemaExporterClientConfigEncoder.createEncoders(providerConfigs);
            String prefix1 = "encrypted.secret.";
            String prefix2 = "encrypted.old.secret.";
            Map<String, Object> encoded1 = providerConfigs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix1)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, Object> encoded2 = providerConfigs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix2)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (encoded1.size() > 1 || encoded2.size() > 1) {
                boolean decoded;
                boolean bl = decoded = encoders.stream().anyMatch(e -> e.decode(prefix1, encoded1, this.configs)) || encoders.stream().anyMatch(e -> e.decode(prefix2, encoded2, this.configs));
                if (!decoded) {
                    throw new ConfigException("Could not decode configs, secrets don't match");
                }
            }
        }

        public ConfigData get(String path) {
            return new ConfigData(this.configs);
        }

        public ConfigData get(String path, Set<String> keys) {
            ConfigData allConfigs = this.get(path);
            HashMap configs = new HashMap(keys.size());
            allConfigs.data().entrySet().stream().filter(e -> keys.contains(e.getKey())).forEach(e -> configs.put((String)e.getKey(), (String)e.getValue()));
            return new ConfigData(configs, allConfigs.ttl());
        }

        public void close() {
            this.configs.clear();
        }
    }

    private static class Encoder {
        protected final String secretPrefix;
        protected final Password secret;
        protected final PasswordEncoder passwordEncoder;

        public Encoder(String secretPrefix, Password secret, PasswordEncoder passwordEncoder) {
            this.secretPrefix = secretPrefix;
            this.secret = secret;
            this.passwordEncoder = passwordEncoder;
        }

        public void addEncodedProp(String key, Password value, Map<String, String> props) {
            try {
                props.put("config.providers.encoder.param.encrypted." + this.secretPrefix + key, this.passwordEncoder.encode(value));
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean decode(String secretPrefix, Map<String, ?> encoded, Map<String, String> decoded) {
            Map<String, Object> props = encoded.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(secretPrefix)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            boolean isMatch = false;
            Object encodedSecret = props.get(secretPrefix);
            if (encodedSecret != null) {
                try {
                    isMatch = this.secret.equals((Object)this.passwordEncoder.decode(encodedSecret.toString()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isMatch) {
                props.entrySet().stream().filter(e -> !((String)e.getKey()).equals(secretPrefix)).forEach(e -> {
                    try {
                        decoded.put(((String)e.getKey()).substring(secretPrefix.length()), this.passwordEncoder.decode(e.getValue().toString()).value());
                    }
                    catch (GeneralSecurityException ex) {
                        throw new RuntimeException(ex);
                    }
                });
            }
            return isMatch;
        }
    }
}

