/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SubjectKey;
import io.confluent.kafka.schemaregistry.storage.SubjectValue;
import io.confluent.schema.exporter.metrics.MetricTags;
import io.confluent.schema.exporter.metrics.MetricsManager;
import io.confluent.schema.exporter.storage.AbstractSchemaExporterTask;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterInfo;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterRunningTask
extends AbstractSchemaExporterTask {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterRunningTask.class);
    private final SchemaRegistryKey key;
    private final SchemaRegistryValue value;
    private final long offset;
    private final long timestamp;
    private final Map<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp> latestValues;
    private final Map<SchemaExporter, Integer> counts;
    private final MetricsManager metricsManager;

    public SchemaExporterRunningTask(SchemaExporterService exporterService, SchemaExporter exporter, SchemaRegistryKey key, SchemaRegistryValue value, long offset, long timestamp, Map<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp> latestValues, Map<SchemaExporter, Integer> counts, MetricsManager metricsManager) {
        super(exporterService, exporter);
        this.key = key;
        this.value = value;
        this.offset = offset;
        this.timestamp = timestamp;
        this.latestValues = latestValues;
        this.counts = counts;
        this.metricsManager = metricsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SchemaExporterStatus status;
        long startTime = System.currentTimeMillis();
        if (!this.exporterService().isLeader()) {
            return;
        }
        log.info("{}: Begin running task", (Object)this.exporter());
        if (!"default".equals(this.tenant())) {
            this.schemaRegistry().setTenant(this.tenant());
        }
        if ((status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter())) == null || status.getState() != SchemaExporterStatus.State.RUNNING || status.getOffset() >= this.offset) {
            log.warn("{}: Abort running task", (Object)this.exporter());
            return;
        }
        try {
            if (this.key instanceof SubjectKey) {
                SchemaExporterInfo info = (SchemaExporterInfo)this.exporterService().exporterInfos().get((Object)this.exporter());
                if (info == null) {
                    log.warn("{}: No info for running task", (Object)this.exporter());
                    return;
                }
                List<String> subjects = SchemaExporterService.getSubjects(info.getSubjects());
                boolean checkMode = subjects.contains(":*:");
                SchemaRegistryClient client = this.getSchemaRegistryClient(info.getConfig());
                long lastOffset = status.getOffset();
                AbstractSchemaExporterTask.OffsetTimestamp latestValue = this.latestValues.get(this.exporter());
                if (latestValue != null && latestValue.getOffset() > lastOffset) {
                    lastOffset = latestValue.getOffset();
                }
                if (lastOffset < this.offset - 1L) {
                    log.info("{}: Catching up from last offset {} to {}", new Object[]{this.exporter(), lastOffset, this.offset});
                    int count = 0;
                    for (String subjectOrPrefix : subjects) {
                        log.info("{}: processing subject {}. Count {} out of {}", new Object[]{this.exporter(), subjectOrPrefix, ++count, subjects.size()});
                        this.exportValues(this.exporter(), client, info, status, subjectOrPrefix, lastOffset, this.offset, checkMode, 1, 0);
                    }
                }
                String tenantPrefix = this.tenant().equals("default") ? "" : this.tenant() + "_";
                SubjectKey subjectKey = (SubjectKey)this.key;
                SubjectValue subjectValue = (SubjectValue)this.value;
                String subject = subjectKey.getSubject();
                boolean doExport = false;
                if (!tenantPrefix.isEmpty()) {
                    if (subject.startsWith(tenantPrefix)) {
                        subject = subject.substring(tenantPrefix.length());
                        doExport = true;
                    }
                } else {
                    doExport = true;
                }
                if (doExport && this.matches(subjects, subject)) {
                    log.info("{}: Exporting subject {}", (Object)this.exporter(), (Object)subject);
                    this.export(this.exporter(), client, info, status, this.tenant(), subjectKey, subjectValue, checkMode);
                    this.counts.compute(this.exporter(), (key, value) -> value == null ? 1 : value + 1);
                }
            }
            this.latestValues.put(this.exporter(), new AbstractSchemaExporterTask.OffsetTimestamp(this.offset, this.timestamp));
            log.info("{}: All caught up", (Object)this.exporter());
        }
        catch (Throwable t) {
            String trace = SchemaExporterRunningTask.trace(t);
            boolean retriable = this.isRetriable(t);
            log.error("{}: Error during export for {}, is retriable ({})", new Object[]{this.exporter(), trace, retriable});
            status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter());
            if (status != null) {
                status.setState(SchemaExporterStatus.State.PAUSED);
                status.setTrace(trace);
                status.setRetriable(retriable);
                this.saveStatus(this.exporter(), status);
            }
            MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), this.exporter().getName(), "exportSchemas", t.getClass().getSimpleName());
            this.metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
        }
        finally {
            long elapsed = System.currentTimeMillis() - startTime;
            this.metricsManager.getTenantMetrics(this.tenant()).getOrCreateLifecycleLatencyGauge(this.exporter().getName(), "RUNNING").set(elapsed);
            log.info("{}: RUNNING task execution latency recorded: {} ms", (Object)this.exporter(), (Object)elapsed);
        }
        log.info("{}: End running task", (Object)this.exporter());
    }
}

