/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.storage.DataEncryptionKey;
import io.confluent.dekregistry.storage.DataEncryptionKeyId;
import io.confluent.dekregistry.storage.EncryptionKey;
import io.confluent.dekregistry.storage.EncryptionKeyId;
import io.confluent.dekregistry.storage.KeyEncryptionKey;
import io.confluent.dekregistry.storage.KeyEncryptionKeyId;
import io.confluent.schema.exporter.metrics.MetricTags;
import io.confluent.schema.exporter.metrics.MetricsManager;
import io.confluent.schema.exporter.storage.AbstractSchemaExporterTask;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterInfo;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterRunningTaskForKeys
extends AbstractSchemaExporterTask {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterRunningTaskForKeys.class);
    private final EncryptionKeyId key;
    private final EncryptionKey value;
    private final long offset;
    private final long timestamp;
    private final Map<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp> latestValues;
    private final Map<SchemaExporter, Integer> counts;
    private final MetricsManager metricsManager;

    public SchemaExporterRunningTaskForKeys(SchemaExporterService exporterService, SchemaExporter exporter, EncryptionKeyId key, EncryptionKey value, long offset, long timestamp, Map<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp> latestValues, Map<SchemaExporter, Integer> counts, MetricsManager metricsManager) {
        super(exporterService, exporter);
        this.key = key;
        this.value = value;
        this.offset = offset;
        this.timestamp = timestamp;
        this.latestValues = latestValues;
        this.counts = counts;
        this.metricsManager = metricsManager;
    }

    @Override
    public void run() {
        SchemaExporterStatus status;
        if (!this.exporterService().isLeader()) {
            return;
        }
        log.info("{}: Begin running task for keys", (Object)this.exporter());
        if (!"default".equals(this.tenant())) {
            this.schemaRegistry().setTenant(this.tenant());
        }
        if ((status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter())) == null || status.getState() != SchemaExporterStatus.State.RUNNING || status.getDeksOffset() >= this.offset) {
            log.warn("{}: Abort running task for keys", (Object)this.exporter());
            return;
        }
        try {
            SchemaExporterInfo info = (SchemaExporterInfo)this.exporterService().exporterInfos().get((Object)this.exporter());
            if (info == null) {
                log.warn("{}: No info for running task for keys", (Object)this.exporter());
                return;
            }
            List<String> subjects = SchemaExporterService.getSubjects(info.getSubjects());
            DekRegistryClient client = this.getDekRegistryClient(info.getConfig());
            long lastOffset = status.getDeksOffset();
            AbstractSchemaExporterTask.OffsetTimestamp latestValue = this.latestValues.get(this.exporter());
            boolean doExport = false;
            if (latestValue != null && latestValue.getOffset() > lastOffset) {
                lastOffset = latestValue.getOffset();
            }
            if (lastOffset < this.offset - 1L) {
                for (String subjectOrPrefix : subjects) {
                    this.exportKeys(this.exporter(), client, info, status, subjectOrPrefix, lastOffset, this.offset);
                }
            }
            if (this.key.getTenant().equals(this.tenant())) {
                if (this.key instanceof KeyEncryptionKeyId) {
                    KeyEncryptionKeyId kekId = (KeyEncryptionKeyId)this.key;
                    KeyEncryptionKey kek = (KeyEncryptionKey)this.value;
                    List dekSubjects = this.dekRegistry().getDekSubjects(kekId.getName(), true);
                    if (this.value == null || dekSubjects.stream().anyMatch(s -> this.matches(subjects, (String)s))) {
                        this.exportKek(this.exporter(), client, info, status, this.tenant(), kekId, kek);
                        doExport = true;
                    } else if (this.value.isDeleted() && dekSubjects.isEmpty()) {
                        this.deleteKek(this.exporter(), client, info, kekId, kek);
                        doExport = true;
                    }
                } else {
                    DataEncryptionKeyId dekId = (DataEncryptionKeyId)this.key;
                    DataEncryptionKey dek = (DataEncryptionKey)this.value;
                    if (this.matches(subjects, dekId.getSubject())) {
                        KeyEncryptionKey kek = this.dekRegistry().getKek(dekId.getKekName(), true);
                        if (kek != null) {
                            this.exportKek(this.exporter(), client, info, status, this.tenant(), kek.toKey(this.tenant()), kek);
                        }
                        this.exportDek(this.exporter(), client, info, status, this.tenant(), dekId, dek);
                        doExport = true;
                    }
                }
            }
            this.latestValues.put(this.exporter(), new AbstractSchemaExporterTask.OffsetTimestamp(this.offset, this.timestamp));
            if (doExport) {
                this.counts.compute(this.exporter(), (key, value) -> value == null ? 1 : value + 1);
            }
        }
        catch (Throwable t) {
            String trace = SchemaExporterRunningTaskForKeys.trace(t);
            boolean retriable = this.isRetriable(t);
            log.error("{}: Error during export for keys ({}), is retriable ({})", new Object[]{this.exporter(), trace, retriable});
            status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter());
            if (status != null) {
                status.setState(SchemaExporterStatus.State.PAUSED);
                status.setTrace(trace);
                status.setRetriable(retriable);
                this.saveStatus(this.exporter(), status);
            }
            MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), this.exporter().getName(), "exportKeys", t.getClass().getSimpleName());
            this.metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
        }
        log.info("{}: End running task for keys", (Object)this.exporter());
    }
}

